/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.widgets.htmleditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Hashtable;

import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;


/**
 * Editor With a Textfield and a Toolbar to edit HTML text.
 * simple formatting suh as Bold, Italic, Underline, Alignment cn be done 
 * vie Toolbar buttons 
 *
 * @Version
 * <br>$Log: HTMLEditor.java,v $
 * <br>Revision 1.14  2013-12-10 11:26:33  ferring
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.13  2010-03-23 15:06:41  troth
 * <br>remove keylistener
 * <br>
 * <br>Revision 1.12  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.11  2008-01-21 16:25:21  heinemann
 * <br>changed image import from IconBuilder to GECAMedModule
 * <br>
 * <br>Revision 1.10  2008-01-21 16:03:56  heinemann
 * <br>using GECAMedModule from core package
 * <br>
 * <br>Revision 1.9  2008-01-15 09:29:39  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.8  2007-12-04 15:13:40  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class HTMLEditor extends JPanel {

	private static final long serialVersionUID = 1L;

	private HTMLEditorKit htmlEditorKit;

	private JEditorPane editorPane;

	private Hashtable<Object, Action> actions;


	/** Creates a new instance of HTMLEditor */
	public HTMLEditor() {
		this.setOpaque(false);
		init();
	}

	private void createActionTable(JTextComponent textComponent) {
		actions = new Hashtable<Object, Action>();
		Action[] actionsArray = textComponent.getActions();
		for (Action a : actionsArray) {
			actions.put(a.getValue(Action.NAME), a);
		}
	}

	private Action getActionByName(String name) {
		return (Action) (actions.get(name));
	}

	private void init() {

		this.setLayout(new BorderLayout());
		
		
		JToolBar toolBar = new JToolBar();
		toolBar.setOpaque(false);
		toolBar.setFloatable(false);
		this.add(toolBar, BorderLayout.NORTH);
		
		toolBar.setFocusable(false);
		
		editorPane = new JEditorPane();
		//editorPane.addKeyListener(this);
		editorPane.firePropertyChange("lineWrap", false, true);
		editorPane.firePropertyChange("wrapStyleWord", false, true);
		htmlEditorKit = new HTMLEditorKit();
		
		editorPane.setEditorKit(htmlEditorKit);

		createActionTable(editorPane);

		Action act = getActionByName(DefaultEditorKit.copyAction);
		act.putValue(Action.SMALL_ICON, GECAMedModule
				.getMiniIcon((GECAMedIconNames.EDIT_COPY)));
		act.putValue(Action.SHORT_DESCRIPTION, "Copy [Ctrl+c]");
		
		toolBar.add(act);

		act = getActionByName(DefaultEditorKit.cutAction);
		act.putValue(Action.SMALL_ICON, GECAMedModule
				.getMiniIcon(GECAMedIconNames.EDIT_CUT));
		act.putValue(Action.SHORT_DESCRIPTION, "Cut [Ctrl+x]");
		toolBar.add(act);

		act = getActionByName(DefaultEditorKit.pasteAction);
		act.putValue(Action.SMALL_ICON, GECAMedModule
				.getMiniIcon(GECAMedIconNames.EDIT_PASTE));
		act.putValue(Action.SHORT_DESCRIPTION, "Paste [Ctrl+v]");
		toolBar.add(act);

		toolBar.addSeparator();

		act = getActionByName("font-bold");
		act.putValue(Action.SMALL_ICON, GECAMedModule
				.getMiniIcon(GECAMedIconNames.TEXT_BOLD));
		act.putValue(Action.SHORT_DESCRIPTION, "Bold [Ctrl+b]");
		toolBar.add(act);
		
		editorPane.getKeymap().addActionForKeyStroke(
				KeyStroke.getKeyStroke(KeyEvent.VK_B, KeyEvent.CTRL_MASK), act);

		act = getActionByName("font-italic");
		act.putValue(Action.SMALL_ICON, GECAMedModule
				.getMiniIcon(GECAMedIconNames.TEXT_ITALIC));
		act.putValue(Action.SHORT_DESCRIPTION, "Italic [Ctrl+i]");
		toolBar.add(act);
		editorPane.getKeymap().addActionForKeyStroke(
				KeyStroke.getKeyStroke(KeyEvent.VK_I, KeyEvent.CTRL_MASK), act);

		act = getActionByName("font-underline");
		act.putValue(Action.SMALL_ICON, GECAMedModule
				.getMiniIcon(GECAMedIconNames.TEXT_UNDER));
		act.putValue(Action.SHORT_DESCRIPTION, "Underline [Ctrl+u]");
		toolBar.add(act);
		editorPane.getKeymap().addActionForKeyStroke(
				KeyStroke.getKeyStroke(KeyEvent.VK_U, KeyEvent.CTRL_MASK), act);

		act = getActionByName("left-justify");
		act.putValue(Action.SMALL_ICON, GECAMedModule
				.getMiniIcon(GECAMedIconNames.TEXT_LEFT));
		act.putValue(Action.SHORT_DESCRIPTION, "Align Left");
		toolBar.add(act);

		act = getActionByName("center-justify");
		act.putValue(Action.SMALL_ICON, GECAMedModule
				.getMiniIcon(GECAMedIconNames.TEXT_CENTER));
		act.putValue(Action.SHORT_DESCRIPTION, "Align Center");
		toolBar.add(act);

		act = getActionByName("right-justify");
		act.putValue(Action.SMALL_ICON, GECAMedModule
				.getMiniIcon(GECAMedIconNames.TEXT_RIGHT));
		act.putValue(Action.SHORT_DESCRIPTION, "Align Right");
		toolBar.add(act);
		
		for (Component comp : toolBar.getComponents())
			comp.setFocusable(false);
		

		editorPane.setEditable(true);
		JScrollPane scrollPane = new JScrollPane(editorPane,
				JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
				JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		this.add(scrollPane, BorderLayout.CENTER);

	}

	public void setText(String text) {
		editorPane.setText(text);
	}

	public String getText() {
		return editorPane.getText();
	}

	
//	public void keyPressed(KeyEvent event) 
//	{
//	if(!event.isConsumed())
//		{
//		switch (event.getKeyChar())    
//			{
//			case KeyEvent.VK_ENTER	  : 
//				try	{				
//					//int caretPos = editorPane.getCaretPosition();
//					//htmlEditorKit.insertHTML((HTMLDocument)editorPane.getDocument(), caretPos, "<BR>", 0, 0, HTML.Tag.BR);
//					//editorPane.setCaretPosition(caretPos + 1);
//					}
//				catch (Exception e) {};
//				break;
//			}
//		}   
//	}
//
//	public void keyTyped(KeyEvent arg0) {	}
//	public void keyReleased(KeyEvent arg0) {}

	
	public void addDocumentListener(DocumentListener listener) {
		editorPane.getDocument().addDocumentListener(listener);
	}
	
	public void removeDocumentListener(DocumentListener listener) {
		editorPane.getDocument().removeDocumentListener(listener);
	}
	
	public void addKeyListener(KeyListener kListener) {
		editorPane.addKeyListener(kListener);
	}
	
	public void removeKeyListener(KeyListener kListener) {
		editorPane.removeKeyListener(kListener);
	}
	
}
