/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/*
 * I18nListPlugin.java
 *
 * Created on July 11, 2005, 3:02 PM
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package lu.tudor.santec.gecamed.core.gui.widgets.hotkeys;

import java.awt.BorderLayout;

import javax.swing.JCheckBox;
import javax.swing.JPanel;

import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.SettingsPlugin;

/**
 * Settings plugin to view and Edit the Hotkeys used in GECAMed
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @Version
 * <br>$Log: HotkeySettingsPlugin.java,v $
 * <br>Revision 1.6  2008-12-22 09:40:00  hermen
 * <br>fixed scrolling
 * <br>
 * <br>Revision 1.5  2008-12-19 08:42:14  hermen
 * <br>fixed scrolling issues
 * <br>
 * <br>Revision 1.4  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-15 09:29:38  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.2  2007-12-04 14:59:04  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class HotkeySettingsPlugin extends SettingsPlugin {
	private static final long serialVersionUID = 1L;

	public final static String NAME = "hotkeys";

	public final static String PATIENTSIDEBAR_HOTKEYS_ENABLED = "PATIENTSIDEBAR_HOTKEYS_ENABLED";

	private JPanel hotkeyOptions;

	private JCheckBox patientsidebarHotkeysEnabled;

	public HotkeySettingsPlugin(String p_Name) {
		super(p_Name);
		this.setStationaryValues();
		buildPanel();
	}
 	
	public HotkeySettingsPlugin() {
		super(NAME);
		this.setStationaryValues();
		buildPanel();
	}

	private void buildPanel() {
		setIcon(GECAMedModule.getIcon(GECAMedModule.HOTKEYS));
		setLabel(Translatrix.getTranslationString("Hotkeys.Settings.Label"));
		
		this.hotkeyOptions = createSubPanel(Translatrix.getTranslationString("Hotkeys.Settings.hotkeyOptions"));
		this.hotkeyOptions.setLayout(new BorderLayout());
		this.patientsidebarHotkeysEnabled = new JCheckBox(Translatrix.getTranslationString("Hotkeys.Settings.PatientHotkeysEnabled"));
		this.hotkeyOptions.add(this.patientsidebarHotkeysEnabled,BorderLayout.WEST);
		addSubPanel(this.hotkeyOptions);
		
		
	}


	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#revertToDefaults()
	 */
	public void revertToDefaults() {
		
		this.patientsidebarHotkeysEnabled.setSelected((Boolean) getDefault(PATIENTSIDEBAR_HOTKEYS_ENABLED));
		
		reflectSettings();
		super.revertToDefaults();
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#updateSettings()
	 */
	public void updateSettings() {
		setValue(PATIENTSIDEBAR_HOTKEYS_ENABLED, (Boolean) this.patientsidebarHotkeysEnabled.isSelected());
	
		super.updateSettings();
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#reflectSettings()
	 */
	public void reflectSettings() {
		super.reflectSettings();
		
		this.patientsidebarHotkeysEnabled.setSelected((Boolean) getValue(PATIENTSIDEBAR_HOTKEYS_ENABLED));
		
		
		this.validate();
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#relocalize()
	 */
	public void relocalize() {
		super.relocalize();
		setLabel(Translatrix.getTranslationString("Hotkeys.Settings.Label"));
	}
	
	/**
	 * set some static defaults
	 */
	public void setStationaryValues() {
		setStationary(PATIENTSIDEBAR_HOTKEYS_ENABLED, true);
	}

}
