package lu.tudor.santec.gecamed.core.gui.widgets.autocompletion;

import java.awt.Window;

import javax.swing.JDialog;
import javax.swing.JFrame;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.Autocompletion;
import lu.tudor.santec.org.fife.ui.autocomplete.AutoCompletionTextComponent;
import lu.tudor.santec.org.fife.ui.autocomplete.MWACHandler;
import lu.tudor.santec.org.fife.ui.autocomplete.MWCompletionProvider;
import lu.tudor.santec.org.fife.ui.autocomplete.dialog.BaseDialogImpl;

public class GECAMedMWACHandler extends MWACHandler
{
	public GECAMedMWACHandler(GECAMedAutoCompletionTextComponent view)
	{
		super(view);
	}
	
	
	@Override
	public void quickAdd()
	{
		if (view == null || view.getSelectedText() == null)
			// if there is no text component set or no text selected, no text can be added
			return;
		
		MWCompletionProvider provider 	= view.getProvider();
		String context 					= provider.getContext();
		String replacementText 			= view.getSelectedText();
		
		if (!"".equals(replacementText))
			if (provider.addCompletionGetFeedback(new GECAMedAutoCompletion(provider, 
					new Autocompletion(context, null, replacementText, null))))
				view.highlightSelectedText(AutoCompletionTextComponent.SUCCESS_HIGHLIGHTING_COLOR, 
						AutoCompletionTextComponent.DEFAULT_HIGHLIGHTING_TIME);
			else
				view.highlightSelectedText(AutoCompletionTextComponent.FAILED_HIGHLIGHTING_COLOR, 
						AutoCompletionTextComponent.DEFAULT_HIGHLIGHTING_TIME);
	}
	
	
	@Override
	public void showSaveCompletionDialog()
	{
		Window owner = BaseDialogImpl.getParentWindow(view);
		if (owner instanceof JDialog)
			new GECAMedSaveCompletionDialog((JDialog)owner, 
					(GECAMedAutoCompletionTextComponent) view).setVisible(true);
		else
			new GECAMedSaveCompletionDialog((JFrame)owner, 
					(GECAMedAutoCompletionTextComponent) view).setVisible(true);
	}
	
	@Override
	public void showEditCompletionDialog()
	{
		Window owner = BaseDialogImpl.getParentWindow(view);
		if (owner instanceof JDialog)
			new GECAMedEditCompletionDialog((JDialog)owner, 
					(GECAMedAutoCompletionTextComponent) view).setVisible(true);
		else
			new GECAMedEditCompletionDialog((JFrame)owner, 
					(GECAMedAutoCompletionTextComponent) view).setVisible(true);
	}
}