/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/*
 * UCMCodeField.java
 *
 * Created on May 26, 2005, 10:41 AM
 */

package lu.tudor.santec.gecamed.core.gui.widgets;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.text.ParseException;

import javax.swing.JFormattedTextField;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.utils.UCMCodeFormatter;

/**
 * The UCMCodeField swing component eases the input of UCM (Union des Caisses de Maladie) 
 * codes. UCM codes come in the format XXXXXX-YY. The 6 Xs represent the actual UCM code
 * whereas the 2 Ys are merely a checksum calculated from the 6 digits. Checksum
 * calculation is a simple module 97 operation. The UCMCodeField coerces the code
 * format and features an autocomplete function.
 * @author nmac
 */

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class UCMCodeField extends JFormattedTextField implements ActionListener                                                           
    {
	private Color m_Foreground;
	private Color m_Background;

	private static final long serialVersionUID = 1L;
    
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public UCMCodeField (AbstractFormatter p_Formatter) 
	{
	super (p_Formatter);
	
	this.setFocusLostBehavior(JFormattedTextField.COMMIT);
	
	this.addActionListener (this);
	m_Foreground = this.getForeground ();
	m_Background = this.getBackground ();
	}
  
//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************

//---------------------------------------------------------------------------

private void reflectValidity ()
	{
	Object			l_Value;
	UCMCodeFormatter	l_Formatter;
		
	l_Value = this.getValue();
	l_Formatter = (UCMCodeFormatter) this.getFormatter();
	l_Formatter.valueToString(l_Value);

	if (this.isEditValid())
		{
		this.setForeground (m_Foreground);
		this.setBackground (m_Background);		
		}		
	else
		{
		this.setForeground (GECAMedColors.c_InvalidFieldForeground);
		this.setBackground (GECAMedColors.c_InvalidFieldBackground);		
		}
	}

//---------------------------------------------------------------------------

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************

//---------------------------------------------------------------------------

public void commitEdit () throws ParseException
	{
	super.commitEdit();
	this.reflectValidity();
	}

//---------------------------------------------------------------------------

public void setValue (Object p_Value)
	{
	super.setValue(p_Value);
	this.reflectValidity();
	}

//---------------------------------------------------------------------------
/**
 * the actionPerformed method, part of the ActionListener interface, intercepts the
 * ENTER key. In the context of the UCMCodeField, the method is either used to complete 
 * the checksum part of the UCM code field if not already specified or to verify the 
 * specified checksum.
 */
//---------------------------------------------------------------------------

public void actionPerformed(ActionEvent p_Event) 
    {
	this.reflectValidity();
   }

//---------------------------------------------------------------------------

public void processFocusEvent (FocusEvent p_Event) 
	{
	if (p_Event.getID() == FocusEvent.FOCUS_GAINED)
		{
		this.setForeground (m_Foreground);
		this.setBackground (m_Background);
		}

	super.processFocusEvent (p_Event);
	}

//---------------------------------------------------------------------------

//***************************************************************************
//* End of Class                                                            *
//***************************************************************************

}
