/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.widgets;

import java.util.HashMap;

import javax.swing.JComboBox;

import lu.tudor.santec.i18n.Translatrix;

/**
 * Combobox that uses Translatrix to translate the items that are shown in the CB.
 * the cb model operates on the untranslated items to be shure to use valid entries
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @Version
 * <br>$Log: TranslatedComboBox.java,v $
 * <br>Revision 1.6  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-08-27 15:34:53  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4  2008-06-03 12:59:11  weitz
 * <br>*letter package, release candidate
 * <br>
 * <br>Revision 1.3  2008-01-15 09:29:38  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.2  2007-12-06 14:46:44  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class TranslatedComboBox extends JComboBox {

	private static final long serialVersionUID = 1L;
	private String key;
	private HashMap<String, String> reverseTranslatrix = new HashMap<String, String>();


	/**
	 * @param className
	 * @param values
	 */
	
	public TranslatedComboBox(Class className, String[] values) {
		this.key = className.getSimpleName() + ".";
		setItems(values);
	}
	
	/**
	 * @param key
	 * @param values
	 */
	public TranslatedComboBox(String key, String[] values) {
		this.key = key + ".";
		setItems(values);
	}
	
	/**
	 * @param items
	 */
	public void setItems(String[] items) {
		if (items == null)
			return;
		for (int i = 0; i < items.length; i++) {
			addSingleItem(items[i]);
//			reverseTranslatrix.put(getTranslation(items[i]), items[i]);
//			this.addItem(getTranslation(items[i]));
		}
	}
	
	/**
	 * @param item
	 */
	public void addSingleItem(String item) {
		/* ================================================== */
		reverseTranslatrix.put(getTranslation(item), item);
		this.addItem(getTranslation(item));
		/* ================================================== */
	}
	
	
	/**
	 * @return
	 */
	public Object getSelectedItemTranslated() {
		return getOrigin((String)super.getSelectedItem());
	}
	
	/**
	 * @param anObject
	 */
	public void setSelectedItemTranslated(Object anObject) {
		super.setSelectedItem(getTranslation((String)anObject));
	}

	/**
	 * if orig exists return Translation, else return original
	 */
	private String getTranslation(String orig) {
		String temp = Translatrix.getTranslationString(key + orig);
		if (temp.equals(key + orig)) {
			return orig;
		} else {
			return temp; 
		}
	}
	
	/**
	 * if  translation exists in hash return orig, else return translation
	 */
	private String getOrigin(String trans) {
		String orig = reverseTranslatrix.get(trans);
		if (orig == null) {
			return trans;
		} else {
			return orig;
		}
	}
	
}
