/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.widgets;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.widgets.gui.ButtonFactory;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * A panel which offers a "search" label, a clear button and 
 * a textfield for the search text.
 * Add an actionlistener  to it to recieve a search action.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 02.09.2008
 * 13:30:31
 *
 *
 * @version
 * <br>$Log: SearchField.java,v $
 * <br>Revision 1.3  2008-12-05 17:34:23  heinemann
 * <br>moved some basic classes to lu.tudor.santec.widgets
 * <br>
 * <br>Revision 1.2  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2008-09-03 10:24:14  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class SearchField extends JPanel implements ActionListener{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private JButton clearButton;
	private JLabel searchLabel;
	private JTextField searchField;
	private JButton searchButton;
	
	private Vector<ActionListener> listeners = new Vector<ActionListener>();
	private int cols = -1;
	
	
	public static final String SEARCH_FIRED = "search_fired";
	
	
	
	public SearchField() {
		/* ================================================== */
		initSearchPanel();
		/* ================================================== */
	}
	
	/**
	 * 
	 */
	public SearchField(int cols) {
		/* ================================================== */
		this.cols  = cols;
		initSearchPanel();
		/* ================================================== */
	}


	/**
	 * inits the panel containing the search field and the buttons
	 */
	private void initSearchPanel() {
		/* ====================================================== */
		this.setLayout(new FormLayout("0dlu," +
													 "fill:pref," +  // clear button
													 "2dlu," +
													 "fill:pref," +  // label
													 "3dlu," +
													 "fill:pref:grow," +  // textfield
													 "3dlu," +
													 "fill:pref," +  // button
													 "3dlu",
													 // rows
													 "0dlu," +
													 "fill:15dlu," +
													 "0dlu" 
													 ));
		/* ------------------------------------------------------- */
		this.setOpaque(false);
		/* ------------------------------------------------------- */
		this.clearButton = ButtonFactory.createEffectButton(GECAMedModule.getMediumIcon(GECAMedIconNames.EDIT_CLEAR_LTR));
		clearButton.addActionListener(this);
		/* ------------------------------------------------------- */
		this.searchLabel = new JLabel(Translatrix.getTranslationString("core.searchAlt")+":");
		/* ------------------------------------------------------- */
		// create the search textfield
		if (cols != -1)
			this.searchField = new JTextField(cols);
		else
			this.searchField = new JTextField();
		this.searchField.addActionListener(this);
//		this.searchField.getDocument().addDocumentListener(this);
		/* ------------------------------------------------------- */
		// create the add button
		/* ------------------------------------------------------- */
		this.searchButton = new JButton(Translatrix.getTranslationString("core.search"));
		this.searchButton.addActionListener(this);
		/* ------------------------------------------------------- */
		// create a buttonpanel for the add buttons
		/* ------------------------------------------------------- */
		// assemble the panel
		/* ------------------------------------------------------- */
		CellConstraints cc = new CellConstraints();
		
		this.add(clearButton, cc.xy(2, 2));
		this.add(searchLabel, cc.xy(4, 2));
		this.add(searchField, cc.xy(6, 2));
		
		this.add(searchButton, cc.xy(8, 2));
		
		/* ====================================================== */
	}

	
	/**
	 * @return the text from the search field
	 */
	public String getText() {
		/* ================================================== */
		return this.searchField.getText();
		/* ================================================== */
	}
	
	
	/**
	 * @param text for the search field
	 */
	public void setText(String text) {
		/* ================================================== */
		this.searchField.setText(text);
		/* ================================================== */
	}
	
	
	/**
	 * Add a listener to be informed when a search has been fired
	 * 
	 * @param l
	 */
	public void addActionListener(ActionListener l) {
		/* ================================================== */
		this.listeners.add(l);
		/* ================================================== */
	}
	

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		/* ====================================================== */
		if (this.clearButton.equals(e.getSource())) {
			/* ------------------------------------------------------- */
			// clear the searchfield and request focus
			/* ------------------------------------------------------- */
			this.searchField.setText("");
			this.searchField.requestFocusInWindow();
			/* ------------------------------------------------------- */
		} else
			if (this.searchField.equals(e.getSource()) || searchButton.equals(e.getSource())) {
				/* ------------------------------------------------------- */
				ActionEvent event = new ActionEvent(this, ActionEvent.ACTION_PERFORMED, SEARCH_FIRED);
				for (ActionListener l : this.listeners) {
					/* ------------------------------------------------------- */
					l.actionPerformed(event);
					/* ------------------------------------------------------- */
				}
				/* ------------------------------------------------------- */
			} 
		/* ====================================================== */
	}
}
