/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.widgets;

import java.awt.BorderLayout;
import java.io.File;
import java.io.FileInputStream;

import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.text.rtf.RTFEditorKit;

/**
 * Dialog to display RTF formated documents
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @Version
 * <br>$Log: RTFViewer.java,v $
 * <br>Revision 1.6  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-01-15 09:29:38  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.4  2007-12-06 14:46:44  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class RTFViewer extends JDialog {

	private static final long serialVersionUID = 1L;
	private JEditorPane editor;
	private int width = 500;

	/**
	 * creates a new viewer dialog
	 * @param title
	 */
	public RTFViewer(String title) {
		initViewer(title);
	}
	
	/**
	 * creates a new viewer dialog
	 * @param parent
	 * @param title 
	 */
	public RTFViewer(JFrame parent, String title) {
		super(parent);
		initViewer(title);
	}
	
	/**
	 * @param title
	 */
	private void initViewer(String title) {
		setTitle(title);
		
		this.setDefaultCloseOperation(JDialog.HIDE_ON_CLOSE);
		
		this.setLayout(new BorderLayout());
		
		this.editor = new JEditorPane();
		this.editor.setEditable(false);
		this.editor.setEditorKit(new RTFEditorKit());
		
		this.add(new JScrollPane(this.editor), BorderLayout.CENTER);
		
		this.setSize(width,  (int)(width*1.4142));
	};
	
	
	/**
	 * shows the provided RTF String
	 * @param doc
	 */
	public void showDocument(String doc) {
		this.editor.setText(doc);
		this.setVisible(true);
	}
	
	/* (non-Javadoc)
	 * @see java.awt.Component#setVisible(boolean)
	 */
	@Override
	public void setVisible(boolean b) {
		if (!b) {
			showDocument("");
		}
		super.setVisible(b);
	}
	
	/**
	 * just for testing
	 * @param args
	 */
	public static void main(String[] args) {
		RTFViewer viewer = new RTFViewer("Viewer");
		
		File f = new File("/home/hermenj/test.rtf");
        byte[] b = new byte[(int) f.length()];
        try {
			new FileInputStream(f).read(b);
		} catch (Exception e) {
		} 	
		viewer.showDocument(new String(b));
		
		viewer.setVisible(true);
	}

}
