/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.widgets;

import java.awt.Image;

import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;

import lu.tudor.santec.gecamed.core.gui.MainFrame;

/**
 * creates a new Dialog to display an image
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @Version
 * <br>$Log: PictureDialog.java,v $
 * <br>Revision 1.5  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-01-15 09:29:38  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.3  2007-12-06 14:46:44  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class PictureDialog extends JDialog {

	private static final long serialVersionUID = 1L;
	JLabel imageLabel = new JLabel();
    
    /**
     * shows a new PictureDialog
     * @param parent the Parent JFrame
     */
    public PictureDialog(JFrame parent) {
        super(parent);
        this.getContentPane().add(imageLabel);
    }
    
    
    /**
     * shows a Dialog with the specified Picture
     * @param ii the Picture to show
     * @param title the Title of the Dialog
     */
    public void showPicture(ImageIcon ii, String title, double xPos, double yPos) {
        if (ii.getIconHeight() > 600 ) {
            ii = new ImageIcon(ii.getImage().getScaledInstance(-1, 600, Image.SCALE_SMOOTH));
        } 
        if (ii.getIconWidth() > 800 ) {
            ii = new ImageIcon(ii.getImage().getScaledInstance(800, -1, Image.SCALE_SMOOTH));
        } 
        this.imageLabel.setIcon(ii);
        this.setTitle(title);
        this.pack();
        this.setLocation((int) xPos, (int) yPos);
        MainFrame.showDialogCentered(this);
    }
    
}
