package lu.tudor.santec.gecamed.core.gui.widgets;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

import lu.tudor.santec.gecamed.core.gui.GECAMedLists;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;

import org.apache.log4j.Logger;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: PhysicianListModel.java,v $
 */

public class PhysicianListModel implements ComboBoxModel, PropertyChangeListener
{
	/* ======================================== */
	// MEMBERS
	/* ======================================== */
	
	/** the logger Object for this class */
	private static Logger logger = Logger.getLogger(PhysicianListModel.class.getName());
	
	
	private ArrayList<Physician>	data;
	
	private List<ListDataListener>	listeners;
	
	private ReloadListener			reloadListener;
	
	
	private int	selectedIndex	= -1;
	
	
	
	/* ======================================== */
	// CONSTRUCTORS
	/* ======================================== */
	
	/**
	 * No arguments required, as this model fills itself with physicians (from GECAMedLists).
	 */
	public PhysicianListModel (ReloadListener listener)
	{
		Set<Physician> sortedPhysicians;
		GECAMedLists.addPropertyChangeListener(new PropertyChangeListener()
		{
			public void propertyChange (PropertyChangeEvent evt)
			{
				reload();
			}
		}, Physician.class);
		
		reloadListener	= listener;
		sortedPhysicians= new TreeSet<Physician>(GECAMedLists.getListReference(Physician.class));
		data			= new ArrayList<Physician>(sortedPhysicians.size() + 1);
		data.addAll(sortedPhysicians);
		listeners		= new LinkedList<ListDataListener>();
	}
	
	
	
	/* ======================================== */
	// CLASS BODY
	/* ======================================== */
	
	public int getSize ()
	{
		return data.size();
	}
	
	
	public Physician getElementAt (int index)
	{
		return data.get(index);
	}
	
	
	public void addListDataListener (ListDataListener l)
	{
		listeners.add(l);
	}
	
	
	public void removeListDataListener (ListDataListener l)
	{
		listeners.remove(l);
	}
	
	
	public void setSelectedItem (Object anItem)
	{
		if (anItem instanceof Physician)
			selectedIndex = data.indexOf(anItem);
		else
			logger.warn("The item to put into the PhysicianListModel must be an instance of Physician.");
	}
	
	
	public Physician getSelectedItem ()
	{
		if (selectedIndex < 0 || selectedIndex >= data.size())
			return null;
		else
			return data.get(selectedIndex);
	}
	
	
	public void reload ()
	{
		if (reloadListener != null)
			reloadListener.prepareReload();
		
		ListDataEvent removeEvent = new ListDataEvent(data, ListDataEvent.INTERVAL_REMOVED, 0, data.size());
		synchronized (data)
		{
			data.clear();
			data.addAll(GECAMedLists.getListReference(Physician.class));
		}
		ListDataEvent addEvent = new ListDataEvent(data, ListDataEvent.INTERVAL_ADDED, 0, data.size());
		
		for (ListDataListener l : listeners)
		{
			l.intervalRemoved(removeEvent);
			l.intervalAdded(addEvent);
		}
		
		if (reloadListener != null)
			reloadListener.reloaded();
	}
	
	
	public void propertyChange (PropertyChangeEvent evt)
	{
		reload();
	}
}
