/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/*
 * Author: Johannes Hermen Tudor/Santec
 * Mail: johannes.hermen@tudor.lu
 * Created: Jan 18, 2005
 *
 */
package lu.tudor.santec.gecamed.core.gui.widgets;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;


/**
 * This Class implements a JTextfield that only allows phonenumbers to be
 * inserted.
 * examples: 0651 1705893
 *           0651/1705893
 *           0651-1705893
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @Version
 * <br>$Log: PhoneField.java,v $
 * <br>Revision 1.5  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-01-15 09:29:38  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.3  2007-12-06 14:46:44  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class PhoneField extends JTextField
{
    //~ Static fields/initializers =============================================

    private static final long serialVersionUID = 1L;

    //~ Instance fields ========================================================

    private Matcher m;
	private int limit = 30;
    private Pattern p = Pattern.compile("[-/ .\\d]*");

    //~ Constructors ===========================================================
    /**
     * creates a new PhoneField
     */
    public PhoneField()
    {
        super();
        this.init();
    }

    /**
     * creates a new PhoneField
     */
    public PhoneField(int limit)
    {
        super();
        this.limit = limit;
        this.init();
    }
    
    //~ Methods ================================================================
    /**
     * do initial settings
     */
    private void init()
    {
        this.setDocument(new PhoneValidation());
        this.setToolTipText("insert PhoneNumbers only!");
    }

    //~ Inner Classes ==========================================================
    /**
     * a Document for the PhoneValidation that only allows PhoneNumbers to be
     * inserted.
     */
    public class PhoneValidation extends PlainDocument
    {
        //~ Static fields/initializers =========================================

        private static final long serialVersionUID = 1L;


        //~ Constructors =======================================================
        /**
         * Constructor for the Validationdocument
         */
        public PhoneValidation()
        {
            super();
        }

        //~ Methods ============================================================

        public void insertString(int offset, String str, AttributeSet attr)
            throws BadLocationException
        {
            // generate matcher for Pattern and String
            m = p.matcher(str);
            if (m.matches()) {
            	if ((getLength() + str.length()) <= limit ) 
            		super.insertString(offset, str, attr);
            } else {
            }
        }
    }
}
