/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * 
 */
package lu.tudor.santec.gecamed.core.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingConstants;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

import lu.tudor.santec.gecamed.core.gui.utils.GradientFactory;

//import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 * @Version
 * <br>$Log: ModuleHeader.java,v $
 * <br>Revision 1.13  2010-12-20 15:42:05  troth
 * <br>GUI redesign of Waitingroom and the Waitingroom get his own usersettingpanel
 * <br>
 * <br>Revision 1.12  2010-03-30 10:55:16  troth
 * <br>Redesign of the prescription view
 * <br>
 * <br>Revision 1.11  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.10  2008-02-13 12:45:46  heinemann
 * <br>fixed problem with color change of the modul header
 * <br>
 * <br>Revision 1.9  2008-02-11 16:47:32  heinemann
 * <br>gradient backgound to the module header
 * <br>
 * <br>Revision 1.8  2008-01-15 09:29:38  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.7  2007-12-06 14:46:44  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 */
public class ModuleHeader extends JPanel {


    private static final long serialVersionUID = 1L;
    private String topic;
    private Icon icon;
    private JLabel headerText;
	private Color color;
	private JPanel buttonPanel;
	private JLabel iconLabel;
	private CellConstraints cc;
	private JPanel metaPanel;
	private boolean showIcon;
    
    /**
     * creates a new Module header Panel
     * @param topic the Module Name to Show
     * @param icon The Icon to show
     * @param color the Backgroundcolor
     */
    public ModuleHeader(String topic, Icon icon, Color color) {
        this.topic = topic;
        this.icon = icon;
        this.color = color;
        initHeader(true);
        
    }
    
    /**
     * creates a new Module header Panel
     * @param color the Backgroundcolor
     */
    public ModuleHeader(Color color) {
        this.color = color;
        initHeader(false);
        
    }
    
    
    /**
     * build s a nice header for the editor
     */
    private void initHeader(boolean showIcon) {
   /* ============================================================================== */  
        this.showIcon = showIcon;
    	// Cellconstraints for the formlayout
        cc = new CellConstraints();
        
        if(showIcon)
        {
        FormLayout headerLayout = new FormLayout(
        		"5dlu, left:pref, 5dlu, left:pref, 3dlu, fill:pref:grow, 5dlu, right:pref ,3dlu"
        		,"center:pref");
        
      /* ============================================================================== */
//        this.setLayout(headerLayout);
        this.setBackground(this.color);
        /* ============================================================================== */
        this.headerText = new JLabel(topic);
        this.headerText.setFont(new Font("Helvetica", Font.BOLD, 20));
      /* ------------------------------------------------------------------------------ */
        iconLabel = new JLabel();
        iconLabel.setBorder(new EmptyBorder(2,2,2,2));
        iconLabel.setIcon(icon);
      /* ------------------------------------------------------------------------------ */            
//      this.buttonPanel = new JPanel(new GridLayout(1,0));
	    this.buttonPanel = new JPanel();
	    this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel,BoxLayout.LINE_AXIS)); 
        this.buttonPanel.setBackground(color);
        this.buttonPanel.setBorder(new EmptyBorder(2,2,2,2));
      /* ============================================================================== */
        this.metaPanel = new JPanel(headerLayout);
        
        metaPanel.add(iconLabel, cc.xy(2, 1));
        metaPanel.add(headerText, cc.xy(4, 1));
        metaPanel.add(buttonPanel, cc.xy(8, 1));
        this.buttonPanel.setOpaque(false);
        metaPanel.setBorder(new LineBorder(Color.RED));
        }else{
        	FormLayout headerLayout = new FormLayout(
            		"5dlu, fill:pref:grow, 5dlu, right:pref ,3dlu"
            		,"center:pref");
            
          /* ============================================================================== */
            this.setBackground(this.color);
        
    	    this.buttonPanel = new JPanel();
    	    this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel,BoxLayout.LINE_AXIS)); 
            this.buttonPanel.setBackground(color);
            this.buttonPanel.setBorder(new EmptyBorder(2,2,2,2));
        
            this.metaPanel = new JPanel(headerLayout);
            
            metaPanel.add(buttonPanel, cc.xy(4, 1));
            this.buttonPanel.setOpaque(false);
            metaPanel.setBorder(new LineBorder(Color.RED));
        }
        this.setLayout(new BorderLayout());
        this.add(GradientFactory.makeGradient(metaPanel, this.color, true), BorderLayout.CENTER);
        
    /* ============================================================================== */
    }    
    
    /**
     * adds a button to the panels right buttonbar
     * @param button
     */
    public void addButton(JComponent button) {
//     	button.setBackground(this.color);
    	if (button instanceof JButton)
    		addEffect((JButton) button);
     	button.setPreferredSize(new Dimension(34,34));
    	this.buttonPanel.add(button);
    	this.buttonPanel.validate();
    }
    
    /**
     * adds a button to the panels right buttonbar at the spezified index
     * @param button
     * @param index
     */
    public void addButton(JComponent button, int index) {
//    	button.setBackground(this.color);
    	if (button instanceof JButton)
    		addEffect((JButton) button);
     	button.setPreferredSize(new Dimension(34,34));
    	this.buttonPanel.add(button, index);
    	this.buttonPanel.validate();
    }
    
 
    /**
     * add a seperator to the buttonbar
     */
    public void addSeparator ()
    	{
    	this.buttonPanel.add(Box.createHorizontalStrut(5));
    	this.buttonPanel.add(new JSeparator(SwingConstants.VERTICAL));
       	this.buttonPanel.add(Box.createHorizontalStrut(5));
   	}
    
    /**
     * add a seperator to the buttonbar at the spezified index
     * @param p_Index
     */
    public void addSeparator (int p_Index)
		{
       	this.buttonPanel.add(Box.createHorizontalStrut(5));
       	this.buttonPanel.add(new JSeparator(SwingConstants.VERTICAL),p_Index);
       	this.buttonPanel.add(Box.createHorizontalStrut(5));
		}
 
    /**
     * removes a button from the panels right buttonbar
     * @param button
     */
    public void removeButton(JComponent button) {
    	this.buttonPanel.remove(button);
    	this.buttonPanel.validate();
    }
    
    /**
     * removes all buttons from the panels right buttonbar
     */
    public void removeAllButtons() {
    	this.buttonPanel.removeAll();
    	this.buttonPanel.validate();
    }


	/**
	 * sets the background color of the ModuleHeader
	 * @param color
	 */
	public void setColor(Color color) {
		/* ================================================== */
		Component [] l_Components;
		int			 l_Index;
		
		this.color = color;
		this.buttonPanel.setBackground(color);
		this.setBackground(this.color);
	
		l_Components = this.buttonPanel.getComponents();
		if (l_Components == null) return;
	    for (l_Index = 0; l_Index < l_Components.length; l_Index++)
	    	l_Components[l_Index].setBackground(this.color);
	    
	    /* ------------------------------------------------------- */
	    this.removeAll();
	    this.add(GradientFactory.makeGradient(metaPanel, this.color, true), BorderLayout.CENTER);
	    
	    this.validate();
	    this.updateUI();
		/* ================================================== */
	}


	/**
	 * sets the icon on the left side of the ModuleHeader
	 * @param icon
	 */
	public void setIcon(Icon icon) {
		this.icon = icon;
		iconLabel.setIcon(icon);
	}


	/**
	 * Sets the string behind the icon on the left side of the ModuleHeader
	 * @param topic
	 */
	public void setTopic(String topic) {
		this.topic = topic;
		headerText.setText (topic);
		headerText.updateUI();
	}
	
	/**
	 * return the topic label of the Moduleheader
	 * @return
	 */
	public JLabel getTopicLabel() {
		return headerText;
	}
	
	/**
	 * sets a component between the topic string and the buttonbar.
	 * @param c
	 */
	public void setHeaderComponent(Component c) {
		if(this.showIcon)
			this.metaPanel.add(c, cc.xy(6, 1));
		else 
			this.metaPanel.add(c, cc.xy(2, 1));
	}
 	
	
	
	/**
	 * @param icon
	 * @param cmd
	 * @param l
	 * @param effects
	 * @return
	 */
	public static void addEffect(final JButton b) {
		/* ================================================== */
		b.setMargin(new java.awt.Insets(0, 0, 0, 0));
		
//		if (effects) {
			b.setFocusable(false);
			
			b.setContentAreaFilled(false);
			b.setBorderPainted(false);
			
			b.addMouseListener(new MouseAdapter() {
	
				@Override
				public void mouseEntered(MouseEvent e) {
					/* ====================================================== */
					b.setBorderPainted(true);
					b.setContentAreaFilled(true);
					/* ====================================================== */
				}
				@Override
				public void mouseExited(MouseEvent e) {
					/* ====================================================== */
					b.setBorderPainted(false);
					b.setContentAreaFilled(false);
					/* ====================================================== */
				}
			});
//		}
		
//		return b;
		/* ================================================== */
	}
	
}
