/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: HeaderedPanel.java,v $
 * <br>Revision 1.3  2010-10-19 14:37:15  troth
 * <br>rename class SimpleViewPanel in OverviewPanel
 * <br>
 * <br>Revision 1.2  2010-03-23 15:06:00  troth
 * <br>add new constructor with para JPanel
 * <br>
 * <br>Revision 1.1  2010-03-12 14:17:42  hermen
 * <br>cleanup of panel layouts and icons
 * <br>
 * <br>Revision 1.3  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-02 13:42:56  heinemann
 * <br>added nice gradient panels
 * <br>
 * <br>Revision 1.1  2007-10-16 08:23:26  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
package lu.tudor.santec.gecamed.core.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

import lu.tudor.santec.gecamed.core.gui.utils.GradientFactory;
import lu.tudor.santec.gecamed.patient.gui.simpleview.OverviewPanel;

/**
 * @author martin.heinemann@tudor.lu
 * 01.10.2007
 * 11:19:07
 *
 *
 * @version
 * <br>$Log: HeaderedPanel.java,v $
 * <br>Revision 1.3  2010-10-19 14:37:15  troth
 * <br>rename class SimpleViewPanel in OverviewPanel
 * <br>
 * <br>Revision 1.2  2010-03-23 15:06:00  troth
 * <br>add new constructor with para JPanel
 * <br>
 * <br>Revision 1.1  2010-03-12 14:17:42  hermen
 * <br>cleanup of panel layouts and icons
 * <br>
 * <br>Revision 1.3  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-02 13:42:56  heinemann
 * <br>added nice gradient panels
 * <br>
 * <br>Revision 1.1  2007-10-16 08:23:26  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class HeaderedPanel extends JPanel {
	
	
	
	public static final Color BORDER_COLOR = new Color(153, 153, 153);
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private JLabel headerLabel;
	private JPanel centerPanel = new JPanel();


	public HeaderedPanel() {
		super();
		initComponent();
	}

	public HeaderedPanel(JPanel centerPanel) {
		super();
		this.centerPanel = centerPanel;
		initComponent();
	}
	
	public HeaderedPanel(boolean isDoubleBuffered) {
		super(isDoubleBuffered);
		initComponent();
	}

	public HeaderedPanel(LayoutManager layout, boolean isDoubleBuffered) {
		super(layout, isDoubleBuffered);
		initComponent();
	}

	public HeaderedPanel(LayoutManager layout) {
		super(layout);
		initComponent();
	}
	
	
	private void initComponent() {
		/* ================================================== */
		super.setLayout(new BorderLayout());
		/* ------------------------------------------------------- */
		this.headerLabel = new JLabel() ;
		headerLabel.setVerticalAlignment(SwingConstants.TOP);
		headerLabel.setVerticalTextPosition(SwingConstants.CENTER);
		
		headerLabel.setOpaque(true);
		headerLabel.setBackground(OverviewPanel.DARK_BACK);
		
		/* ------------------------------------------------------- */
		centerPanel.setOpaque(false);
		this.setOpaque(false);
		
		super.setBorder(BorderFactory.createLineBorder(BORDER_COLOR));
		
		/* ------------------------------------------------------- */
		super.add(GradientFactory.makeGradient(headerLabel), BorderLayout.NORTH);
		super.add(centerPanel, BorderLayout.CENTER);
		
		
		
		/* ================================================== */
	}
	
	public void setHeader(String text) {
		/* ================================================== */
		this.headerLabel.setText(" " + text);
		/* ================================================== */
	}
	
	public void setHeaderIcon(Icon icon) {
		/* ================================================== */
		this.headerLabel.setIcon(icon);
		/* ================================================== */
	}

	
	public void enableAlpha(boolean b) {
		/* ================================================== */
		if (b) {
			Color s = OverviewPanel.DARK_BACK;
			Color c = new Color(s.getRed(), s.getGreen(),  s.getBlue(), 65);
			headerLabel.setBackground(c);
		} else
			headerLabel.setBackground(OverviewPanel.DARK_BACK);
		/* ================================================== */
	}
	
	
	// ===========================================================
	// Override JPanel methods
	//
	// ===========================================================
	
	
	@Override
	public Component add(Component comp, int index) {
		/* ====================================================== */
		return centerPanel.add(comp, index);
		/* ====================================================== */
	}

	@Override
	public void add(Component comp, Object constraints, int index) {
		/* ====================================================== */
		centerPanel.add(comp, constraints, index);
		/* ====================================================== */
	}

	@Override
	public void add(Component comp, Object constraints) {
		/* ====================================================== */
		centerPanel.add(comp, constraints);
		/* ====================================================== */
	}

	@Override
	public Component add(Component comp) {
		/* ====================================================== */
		return centerPanel.add(comp);
		/* ====================================================== */
	}

	@Override
	public Component add(String name, Component comp) {
		/* ====================================================== */
		return centerPanel.add(name, comp);
		/* ====================================================== */
	}
	@Override
	public void setLayout(LayoutManager mgr) {
		/* ====================================================== */
		if (centerPanel != null)
			centerPanel.setLayout(mgr);
		/* ====================================================== */
	}
	

}
