/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.widgets;

import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.utils.GECAMedGuiUtils;
import lu.tudor.santec.gecamed.core.gui.utils.TableSorter;
import lu.tudor.santec.gecamed.core.gui.widgets.searchtableheader.SearchTableHeader;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class GenericRenderer extends DefaultTableCellRenderer implements Relocalizable
	{	
	private JLabel              			m_Label;
	private DateFormat    					m_DateFormat;
	private DateFormat		    			m_DateTimeFormat;
	private NumberFormat					m_CurrencyFormat;
	private TableSorter						m_TableSorter;
	private SearchTableHeader				m_SearchHeader;
	protected Date							m_Today;
	protected boolean						m_IsAlarm;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	private static final long serialVersionUID = 1L;
 	
	public static final Date c_Epoch  = new Date (0);
	
	public static final Double c_Zero = Double.valueOf (0);
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
   
public GenericRenderer ()
     {
     super();

     m_Label = new JLabel ();
     m_Label.setOpaque(true);
     m_Label.setHorizontalAlignment (SwingConstants.CENTER);
  
     this.relocalize();       
     }

//***************************************************************************
//* Class Primitives		                                                *
//***************************************************************************

//---------------------------------------------------------------------------

protected String formatDate (Date p_Date)
	{
	if (p_Date.equals (c_Epoch))
		 return "";
	else return m_DateFormat.format (p_Date);
	}

//---------------------------------------------------------------------------

protected String formatDateTime (Date p_Date)
	{
	if (p_Date.equals (c_Epoch))
		 return "";
	else return m_DateTimeFormat.format (p_Date);
	}

//---------------------------------------------------------------------------

protected String formatAmount (Double p_Amount)
	{
	if (p_Amount != null)
		 return m_CurrencyFormat.format (p_Amount);
	else return m_CurrencyFormat.format (c_Zero);
	}

//---------------------------------------------------------------------------

protected int modelRow (int p_ViewRow)
	{
	int	l_ModelRow;
	
	l_ModelRow = p_ViewRow;
	
	if ((m_TableSorter != null) && m_TableSorter.isSorting())
		{
		l_ModelRow = m_TableSorter.modelIndex(l_ModelRow);
		}
	
	return l_ModelRow;
	}

//---------------------------------------------------------------------------

protected int modelColumn (JTable p_Table, int p_ViewColumn) 
	{
    if (p_Table == null) return -1;
	
	if (p_ViewColumn >= p_Table.getColumnCount()) return -1;
  
    return p_Table.getColumnModel().getColumn(p_ViewColumn).getModelIndex();
	}

//---------------------------------------------------------------------------

protected Color getBackground (int p_Row, int p_Column)
	{
	Color l_Background = Color.WHITE;
	
	if (!m_IsAlarm)
		{
		if ((m_SearchHeader != null) && (m_SearchHeader.isSearchColumn(p_Column)))
			{
			l_Background = ( p_Row % 2 == 0) ? GECAMedColors.c_OddLineSearchBackground : 
			 							   	   GECAMedColors.c_EvenLineSearchBackground;
			}
		else
			{
			l_Background = ( p_Row % 2 == 0) ? GECAMedColors.c_OddLineBackground : 
									 	   	   GECAMedColors.c_EvenLineBackground;
			}
		}
	else
		{
		if ((m_SearchHeader != null) && (m_SearchHeader.isSearchColumn(p_Column)))
			{
			l_Background = ( p_Row % 2 == 0) ? GECAMedColors.c_RedOddLineSearchBackground : 
		 						     	   	   GECAMedColors.c_RedEvenLineSearchBackground;
			}
		else
			{
			l_Background = ( p_Row % 2 == 0) ? GECAMedColors.c_RedOddLineBackground : 
	     	   							       GECAMedColors.c_RedEvenLineBackground;
			}
		}

	return l_Background;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

public void setSearchHeader (SearchTableHeader p_SearchHeader)
	{
	m_SearchHeader = p_SearchHeader;
	}

//---------------------------------------------------------------------------

public SearchTableHeader getSearchHeader ()
	{
	return m_SearchHeader;
	}

//---------------------------------------------------------------------------

public void setTableSorter (TableSorter p_TableSorter)
	{
	m_TableSorter = p_TableSorter;
	}

//---------------------------------------------------------------------------

public TableSorter getTableSorter ()
	{
	return m_TableSorter;
	}

//---------------------------------------------------------------------------

public void setAlarm (boolean p_IsAlarm)
	{
	m_IsAlarm = p_IsAlarm;
	}

//---------------------------------------------------------------------------

public boolean getAlarm ()
	{
	return m_IsAlarm;
	}

//---------------------------------------------------------------------------
/**
 * Method is part of the Relocalizable interface. The method does everything
 * required to reflect changes of active Locale
 */
//---------------------------------------------------------------------------

public void relocalize() 
	{
   
    m_DateFormat = GECAMedGuiUtils.getDateFormat(false);
    m_DateTimeFormat = GECAMedGuiUtils.getDateTimeFormat(false);
        
//    m_CurrencyFormat = NumberFormat.getCurrencyInstance (Translatrix.getLocale());
    m_CurrencyFormat = NumberFormat.getCurrencyInstance (Locale.FRANCE);
    m_CurrencyFormat.setCurrency(Currency.getInstance ("EUR"));
	}

//---------------------------------------------------------------------------

public Component getTableCellRendererComponent (JTable p_Table, Object p_Value,
        										 boolean p_IsSelected, 
        										 boolean p_HasFocus, 
        										 int p_Row, int p_Column) 
	{
	Color			l_Background;
	int				l_Column = -1;
	
	m_Label.setIcon (null);
	m_Label.setToolTipText (null);
	m_Label.setText ("");
	m_Label.setHorizontalAlignment (SwingConstants.CENTER);
	m_Label.setForeground (Color.BLACK);

	if (p_Table != null) 
		{
		m_Label.setEnabled (p_Table.isEnabled());
		l_Column = this.modelColumn (p_Table, p_Column);
		}

	l_Background = this.getBackground(p_Row, l_Column);	
		
	if ((p_Table != null) && (p_IsSelected)) 
		{
		m_Label.setBackground (p_Table.getSelectionBackground());
		} 
	else 
		{
		m_Label.setBackground (l_Background);
		}
			
	return m_Label;
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
