/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.widgets;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;

/**
 * a JTextfield that only allows e-mail-addresses of the format xxx@yyy.zz
 * to be inserted.
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @Version
 * <br>$Log: EMailField.java,v $
 * <br>Revision 1.8  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.7  2008-04-30 12:18:38  hermen
 * <br>initial checkin of Addressbook module
 * <br>
 * <br>Revision 1.6  2008-01-15 09:29:38  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.5  2007-12-06 14:46:44  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class EMailField extends JTextField
{
    //~ Static fields/initializers =============================================

    private static final long serialVersionUID = 1L;
    private static final Color INVALID_BACKGROUND = GECAMedColors.c_InvalidFieldBackground;
    private static final Color VALID_BACKGROUND = new JTextField().getBackground();

    //~ Instance fields ========================================================

    private Matcher m;
    private Pattern p = Pattern.compile(
            "[-_.a-zA-Z0-9]{2,}@[-_.a-zA-Z0-9]{2,}[.][a-zA-Z]{2,}");
    
    private boolean isValid = false;
    
    
    //~ Constructors ===========================================================
    /**
     * creates a new EmailField
     */
    public EMailField()
    {
        super();
        this.init();
    }

    /**
     * creates a new EmailField
     *
     * @param text the Text to be shown
     */
    public EMailField(String text)
    {
        super(text);
        this.init();
    }

    /**
     * creates a new EmailField
     *
     * @param columns the length of the Field
     */
    public EMailField(int columns)
    {
        super(columns);
        this.init();
    }

    //~ Methods ================================================================
    /**
     * do initial settings
     */
    private void init()
    {
        this.setDocument(new EmailValidation());
        this.setToolTipText("insert valid E-Mail Adresses only!");
    }
    
   
    /**
     * @return
     */
    public boolean isAddressValid() {
    	/* ================================================== */
    	return this.isValid;
		/* ================================================== */
    }
    
    
    //~ Inner Classes ==========================================================
    /**
     * a Document for the EmailField that only allows valid EmailAddresses to be
     * inserted.
     */
    public class EmailValidation extends PlainDocument
    {
        //~ Static fields/initializers =========================================

        private static final long serialVersionUID = 1L;

        //~ Constructors =======================================================
        /**
         * Constructor for the Validationdocument
         */
        public EmailValidation()
        {
            super();
        }

        //~ Methods ============================================================
        /**
         * overwrites insertString of Class PlainDocument
         *
         * @param offset offset: Position
         * @param str str: the String
         * @param attr attr: Attributset
         *
         * @throws BadLocationException
         */
        public void insertString(int offset, String str, AttributeSet attr)
            throws BadLocationException
        {
            super.insertString(offset, str, attr);

            // generate matcher for Pattern and String
            m = p.matcher(EMailField.this.getText());
            if (m.matches()) {
                EMailField.this.setBackground(VALID_BACKGROUND);
                isValid = true;
            } else {
                EMailField.this.setBackground(INVALID_BACKGROUND);
                isValid = false;
//                java.awt.Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}
