/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/*
 * Author: Johannes Hermen Tudor/Santec
 * Mail: johannes.hermen@tudor.lu
 * Created: Mar 3, 2005
 *
 */
package lu.tudor.santec.gecamed.core.gui.widgets;

import java.awt.Color;

import javax.swing.JLabel;


/**
 * a JLabel with a Constructor to set the TextColor to make life a bit easier
 *
 * @author Johannes Hermen johannes.hermen@tudor.lu Tudor/Santec
 */
public class ColorLabel extends JLabel
{
    //~ Static fields/initializers =============================================

    private static final long serialVersionUID = 1L;

    //~ Constructors ===========================================================

    public ColorLabel()
    {
        super();
    }

    public ColorLabel(String text)
    {
        super();
        this.setText(text);
    }

    public ColorLabel(Color color)
    {
        super();
        this.setForeground(color);
    }

    public ColorLabel(String text, Color color)
    {
        super();
        this.setForeground(color);
        this.setText(text);
    }

    //~ Methods ================================================================

    public void setText(String text)
    {
        super.setText(text);
    }
}
