/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.widgets;

import java.awt.Graphics;

import javax.swing.Icon;
import javax.swing.JLabel;

/**
 * JLabel with nice, round corners
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @Version
 * <br>$Log: BubbleLabel.java,v $
 * <br>Revision 1.4  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-15 09:29:38  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.2  2007-12-06 14:46:44  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class BubbleLabel extends JLabel {
	private static final long serialVersionUID = 1L;

	/**
	 * creates a BubbleLabel with the given icon
	 * @param image
	 */
	public BubbleLabel(Icon image) {
		super(image);
		setOpaque(false);
	}

	/**
	 * creates a BubbleLabel with the given icon, text and alignment
	 * @param text
	 * @param icon
	 * @param horizontalAlignment
	 */
	public BubbleLabel(String text, Icon icon, int horizontalAlignment) {
		super(text, icon, horizontalAlignment);
		setOpaque(false);
	}

	/**
	 * creates a BubbleLabel with the given text
	 * @param text
	 */
	public BubbleLabel(String text) {
		super(text);
		setOpaque(false);
	}

	/* (non-Javadoc)
	 * @see javax.swing.JComponent#printComponent(java.awt.Graphics)
	 */
	@Override
	protected void paintComponent(Graphics g) {
		// draw a round edged background instead of the normal JLabel
		g.setColor(getBackground());
		g.fillRoundRect(0,0, getWidth(), getHeight(), 8,8);
		super.paintComponent(g);
	}

	
	
}
