package lu.tudor.santec.gecamed.core.gui.utils.script;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.gecamed.letter.gui.placeholders.ScriptingManager;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Logger;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: ScriptTestDialog.java,v $
 */

public class ScriptTestDialog extends GECAMedBaseDialogImpl
{
	/* ======================================== */
	// CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	/** the logger Object for this class */
	private static Logger logger = Logger.getLogger(ScriptTestDialog.class.getName());
	
	
	
	/* ======================================== */
	// MEMBERS
	/* ======================================== */
	
	private static ScriptTestDialog	instance;
	
	
	private JButton		loadScriptButton;
	
	private JTextField	scriptFileField;
	
	private JButton		executeScriptButton;
	
	private File		scriptFile;
	
	
	
	/* ======================================== */
	// CONSTRUCTORS
	/* ======================================== */
	
	private ScriptTestDialog ()
	{
		super(MainFrame.getInstance(), 
				Translatrix.getTranslationString("Test script"), 
				OK_BUTTON_MODE);
		
		JLabel	label		= new JLabel(
				"<html>Choose a script file and execute it.<br>"
				+ "The result or the errors are shown in the client log.</html>");
		
		loadScriptButton	= new JButton(new AbstractAction("load script file")
		{
			private static final long	serialVersionUID	= 1L;

			public void actionPerformed (ActionEvent e)
			{
				loadScriptFile();
			}
		});
		
		scriptFileField		= new JTextField();
		scriptFileField.setEditable(false);
		
		executeScriptButton	= new JButton(new AbstractAction("execute script file")
		{
			private static final long	serialVersionUID	= 1L;

			public void actionPerformed (ActionEvent e)
			{
				executeScript();
			}
		});
		
		mainPanel.setLayout(new FormLayout(
				// columns
				"5px, f:p, 10px, f:p:g, 5px",
				// rows
				"5px,f:p," +	// description 
				"5px,f:p," +	// load script
				"5px,f:p," +	// execute
				"5px"));
		
		CellConstraints cc = new CellConstraints();
		mainPanel.add(label,				cc.xyw(2, 2, 3));
		mainPanel.add(loadScriptButton,		cc.xyw(2, 4, 1));
		mainPanel.add(scriptFileField,		cc.xyw(4, 4, 1));
		mainPanel.add(executeScriptButton,	cc.xyw(2, 6, 3));
	}
	
	
	
	/* ======================================== */
	// CLASS BODY
	/* ======================================== */
	
	public static void showDialog ()
	{
//		if (instance == null)
			instance = new ScriptTestDialog();
		
		instance.init();
		instance.pack();
		instance.showCenteredDialog();
	}
	
	
	
	/* ======================================== */
	// HELP METHODS
	/* ======================================== */
	
	private void init ()
	{
		scriptFile = null;
		scriptFileField.setText("");
		executeScriptButton.setEnabled(false);
	}
	
	
	private void loadScriptFile ()
	{
		JFileChooser fileChooser = MainFrame.getFileChooser();
		
		
		try
		{
			fileChooser.setFileFilter(new FileFilter()
			{
				@Override
				public String getDescription ()
				{
					return ".js";
				}
				
				
				@Override
				public boolean accept (File f)
				{
					return f.isDirectory() || f.getName().toLowerCase().endsWith(".js");
				}
			});
			fileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
			
			if (fileChooser.showOpenDialog(this) != JFileChooser.APPROVE_OPTION)
				return;
			
			scriptFile = fileChooser.getSelectedFile();
			scriptFileField.setText(scriptFile.getPath());
			executeScriptButton.setEnabled(true);
		}
		finally
		{
			fileChooser.resetChoosableFileFilters();
		}
	}
	
	
	private void executeScript ()
	{
		if (scriptFile != null && scriptFile.exists())
		{
			try
			{
				Reader reader = new FileReader(scriptFile);
				ScriptingManager scriptingManager = new ScriptingManager();
				scriptingManager.test(reader, null);
			}
			catch (FileNotFoundException e)
			{
				logger.error("Error while reading script file "+scriptFile.getPath(), e);
			}
		}
		else
		{
			executeScriptButton.setEnabled(false);
		}
	}
}
