package lu.tudor.santec.gecamed.core.gui.utils;

import ij.plugin.BrowserLauncher;

import java.io.IOException;
import java.net.URI;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: UrlOpener.java,v $
 * <br>Revision 1.3  2013-12-27 18:08:13  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.2  2013-07-15 06:18:34  ferring
 * <br>logging changed
 * <br>
 * <br>Revision 1.1  2013-07-02 09:22:28  ferring
 * <br>Browsing URL changed
 * <br>
 */

public class UrlOpener extends Thread
{
	/** the logger Object for this class */
	private static Logger logger = Logger.getLogger(UrlOpener.class.getName());
	
	
	
	public static boolean openURL (String url)
	{
		if (!browseViaDesktopApi(url))
		{
			try
			{
				BrowserLauncher.openURL(url);
			}
			catch (IOException e)
			{
				logger.log(Level.ERROR, "Unable to open URL \""+url+" \"", e);
				return false;
			}
		}
		
		return true;
	}
	
	
	private static boolean browseViaDesktopApi (String url)
	{
		try
		{
			java.awt.Desktop.getDesktop().browse(new URI(url));
			logger.info("using Desktop API to open URL");
			return true;
		}
		catch (Throwable e) 
		{
			return false;
		}
	}
}
