/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/*
 * Author: Johannes Hermen Tudor/Santec
 * Mail: johannes.hermen@tudor.lu
 * Created: Feb 1, 2005
 *
 */
package lu.tudor.santec.gecamed.core.gui.utils;

import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import lu.tudor.santec.i18n.Translatrix;


/**
 * A comboboxtrenderer that shows the Translated Items in the combobox.
 * The Translatrion is retrieved by Translatrix.getTranslationString(translatrixPrefix + "." + value.toString())
 * 
 * @author Johannes Hermen johannes.hermen
 */
public class TranslatrixComboBoxRenderer extends JLabel implements ListCellRenderer
{
    //~ Static fields/initializers =============================================

    private static final long serialVersionUID = 1L;
	private String translatrixPrefix;

    //~ Constructors ===========================================================
    /**
     * builds a new DefaultComboboxRenderer
     */
    public TranslatrixComboBoxRenderer(Class className)
    {
    	this.translatrixPrefix = className.getSimpleName();
        setOpaque(true);
        setHorizontalAlignment(LEFT);
        setVerticalAlignment(CENTER);
    }

    //~ Methods ================================================================

    /*
     * (non-Javadoc)
     *
     * @see javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList,
     *      java.lang.Object, int, boolean, boolean)
     */
    public Component getListCellRendererComponent(JList list, Object value,
        int index, boolean isSelected, boolean cellHasFocus)
    {
        if (isSelected) {
            setBackground(list.getSelectionBackground());
            setForeground(list.getSelectionForeground());
        } else {
            setBackground(list.getBackground());
            setForeground(list.getForeground());
        }
        try {
    		if (value == null ) {
    			this.setText("");
    		} else {
	        	String text = Translatrix.getTranslationString(translatrixPrefix + "." + value.toString());
	        	if ((translatrixPrefix + "." + value.toString()).equals(text)) {
	       			this.setText(value.toString());
	        	} else {
	        		this.setText(Translatrix.getTranslationString(translatrixPrefix + "." + value.toString()));	
	        	}
    		}
        } catch (Exception e) {
            this.setText(value + "");
        }
        return this;
    }
}
