package lu.tudor.santec.gecamed.core.gui.utils;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.io.IOException;
import java.io.StringReader;

import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

/**
 * @author martin.heinemann@tudor.lu
 *         06.05.2009
 *         13:58:21
 * 
 * 
 * @version
 * <br>
 *          $Log: StringHelper.java,v $
 *          Revision 1.3  2013-03-08 15:07:59  kutscheid
 *          fix some UI glitches
 *          add functionalities tothe import table
 *          add a method to calculate string widths easily
 * <br>
 *          Revision 1.2 2012-11-06 08:02:01 ferring <br>
 *          Reporting improved <br>
 * <br>
 *          Revision 1.1 2009-05-06 15:58:08 heinemann <br>
 *          initial checkin <br>
 * 
 */
public class StringHelper {

	public static final String NEWLINE = "\n";
	public static final String TAB = "\t";

	/**
	 * Checks if the input is null. If yes it will return
	 * an empty string. This helps to avoid stupid
	 * "null" strings in guis.
	 * 
	 * @param input
	 * @return
	 */
	public static String checkNull(String input) {
		/* ================================================== */
		if (input != null)
			return input;
		return "";
		/* ================================================== */
	}

	/**
	 * Checks if the input is null. If yes it will return
	 * an empty string. This helps to avoid stupid
	 * "null" strings in guis.
	 * 
	 * @param prefix
	 *            a string that should be printed in front of the input.
	 * @param input
	 * @return
	 */
	public static String checkNull(String prefix, String input) {
		/* ================================================== */
		if (input != null)
			return checkNull(prefix) + input;
		return "";
		/* ================================================== */
	}

	//
	/**
	 * This method takes html string and returns all text in the document.
	 * 
	 * @param htmlText
	 * @return
	 */
	public static String getText(String htmlText) {
		/* ================================================== */
		final StringBuffer buf = new StringBuffer();

		try {
			// Create an HTML document that appends all text to buf
			HTMLDocument doc = new HTMLDocument() {
				private static final long serialVersionUID = 1L;

				public HTMLEditorKit.ParserCallback getReader(int pos) {

					return new HTMLEditorKit.ParserCallback() {
						// This method is whenever text is encountered in the
						// HTML file
						public void handleText(char[] data, int pos) {
							buf.append(data);
							buf.append('\n');
						}
					};
				}
			};

			// Create a reader on the HTML content
			StringReader sr = new StringReader(htmlText);
			// Parse the HTML
			EditorKit kit = new HTMLEditorKit();
			kit.read(sr, doc, 0);

		} catch (BadLocationException e) {
		} catch (IOException e) {
		}

		// Return the text
		return buf.toString();
		/* ================================================== */
	}

	public static Dimension getTextSize(JTextComponent textComponent) {
		FontMetrics metrics = textComponent.getFontMetrics(textComponent.getFont());
		int width = 0;
		int height = 0;
		int lineWidth = 0;
		int lineHeight = metrics.getHeight();
		int[] widths = metrics.getWidths();
		String text = textComponent.getText();
		char letter;

		if (text != null && text.length() > 0) {
			for (int i = 0; i < text.length(); i++) {
				letter = text.charAt(i);

				if (letter == '\n') {
					// one more line found
					height += lineHeight;
					if (width < lineWidth)
						width = lineWidth;

					lineWidth = 0;
				} else {
					// one more letter found in this line
					if (letter < 256)
						lineWidth += widths[letter];
					else
						lineWidth += widths['m'];
				}
			}

			height += lineHeight;
			if (width < lineWidth)
				width = lineWidth;
		}

		return new Dimension(width + 20, height + 15);
	}

	/**
	 * Calculate the Size of some text if it is displayed in a JComponent. This
	 * method calculates as if the text were displayed in a single line
	 * 
	 * @param component A JComponent used as the calculation basis of this method (the graphics context is used
	 * @param text The text to be measured
	 * @return The width of the given text inside the given JComponent as if it was only displayed in a single line.
	 */
	public static int getTextWidth(JComponent component, String text) {
		return component.getGraphics().getFontMetrics().stringWidth(text) + 20;
	}
}
