package lu.tudor.santec.gecamed.core.gui.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.MenuBar;

import com.jgoodies.forms.layout.FormLayout;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: GECAMedHelp.java,v $
 * <br>Revision 1.2  2013-09-09 08:42:10  ferring
 * <br>Help button deactivated
 * <br>
 * <br>Revision 1.1  2013-07-15 06:18:34  ferring
 * <br>logging changed
 * <br>
 */

public class GECAMedHelp extends AbstractAction implements MouseListener
{
	/* ======================================== */
	// CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	
	
	/* ======================================== */
	// MEMBERS
	/* ======================================== */
	
	private static Cursor helpCursor;
	
	
	private boolean helpModeActive	= false;
	
	private JPanel	glassPane;
	
	private AbstractButton	helpButton;
	
	
	
	/* ======================================== */
	// CONSTRUCTORS
	/* ======================================== */
	
	public GECAMedHelp (MenuBar bar)
	{
		super("?");
		
		Dimension size	= new Dimension(24, 64);
		helpButton		= new JMenuItem(this);
//		helpButton.setMargin(new Insets(1, 1, 1, 1));
		helpButton.setName("GECAMedHelpButton");
		helpButton.setOpaque(false);
//		helpButton.setPreferredSize(size);
//		helpButton.setSize(size);
		helpButton.setMaximumSize(size);
		bar.add(helpButton);
	}
	
	
	
	/* ======================================== */
	// CLASS BODY
	/* ======================================== */
	
	/* ---------------------------------------- */
	// MOUSE LISTENER METHODS
	/* ---------------------------------------- */
	
	public void mouseClicked (MouseEvent e)
	{
		if (helpModeActive)
		{
			MainFrame frame = MainFrame.getInstance();
			Point p = e.getPoint();
			Component component;
			
			
			disableHelpMode();
			frame.validate();
			
			component = getDeepestComponentAt(frame, p.x, p.y);
			
			String	clazz;
			String	name;
			
			while (component != null)
			{
				name		= component.getName();
				clazz		= component.getClass().getCanonicalName();
				
				if (clazz.startsWith("lu.tudor.santec.gecamed"))
					System.out.println("Class: "+clazz);
				else if (name != null)
					System.out.println("Name: "+name);
				
				component	= component.getParent();
			}
		}
	}
	
	
	public void mousePressed (MouseEvent e)
	{
		if (helpModeActive && e.isPopupTrigger())
			disableHelpMode();
	}
	
	
	public void mouseReleased (MouseEvent e)
	{
		if (helpModeActive && e.isPopupTrigger())
			disableHelpMode();
	}
	
	
	public void mouseEntered (MouseEvent e) {}
	public void mouseExited (MouseEvent e) {}
	
	
	/* ---------------------------------------- */
	// ABSTRACT ACTION METHODS
	/* ---------------------------------------- */
	
	public void actionPerformed (ActionEvent e)
	{
		if (helpModeActive)
			disableHelpMode();
		else
			enableHelpMode();
	}
	
	
	
	/* ======================================== */
	// HELP METHODS
	/* ======================================== */
	
	private void disableHelpMode ()
	{
		MainFrame frame = MainFrame.getInstance();
		helpModeActive = false;
		System.out.println("Help Mode disabled!");
		
		frame.setCursor(Cursor.getDefaultCursor());
		frame.getGlassPane().setVisible(false);
	}
	
	
	private void enableHelpMode ()
	{
		JFrame frame = MainFrame.getInstance();
		helpModeActive	= true;
		System.out.println("Help Mode enabled!");
		
		Cursor helpCursor = getHelpCursor();
		frame.setCursor(helpCursor);
		JPanel glassPane = getGlassPane();
		frame.setGlassPane(glassPane);
		glassPane.setVisible(true);
		glassPane.setCursor(helpCursor);
	}
	
	
	private Cursor getHelpCursor ()
	{
//		if (helpCursor == null)
//		{
			Toolkit toolkit = Toolkit.getDefaultToolkit();
			Image cursorImage = GECAMedModule.getSmallIcon("helpCursor.png").getImage(); //.getScaledInstance(32, 32, Image.SCALE_DEFAULT);
			Point hotSpot = new Point(0, 0);
			helpCursor = toolkit.createCustomCursor(cursorImage, hotSpot, "Help");
			try
			{
//				helpCursor = Cursor.getSystemCustomCursor("HelpSelect");
//				helpCursor = Cursor.getPredefinedCursor(Cursor.CROSSHAIR_CURSOR);
			}
			catch (Exception e)
			{
				helpCursor = null;
			}
			
			if (helpCursor == null)
				helpCursor = Cursor.getPredefinedCursor(Cursor.HAND_CURSOR);
//		}
//		helpCursor = Cursor.getPredefinedCursor(Cursor.HAND_CURSOR);
		
		return helpCursor;
	}
	
	
	private JPanel getGlassPane ()
	{
		if (glassPane == null)
		{
			glassPane	= new JPanel(new FormLayout("0px:g", "0px:g"));
			glassPane.setOpaque(false);
//			glassPane.setBackground(Color.YELLOW);
			glassPane.addMouseListener(this);
		}
		
		return glassPane;
	}
	
	
	public static Component getDeepestComponentAt (Component parent, int x, int y)
	{
		if (!parent.contains(x, y))
		{
			return null;
		}
		
		if (parent instanceof Container)
		{
			Component components[] = ((Container) parent).getComponents();
			for (int i = 0; i < components.length; i++)
			{
				Component comp = components[i];
				if (comp != null && comp.isVisible())
				{
					Point loc = comp.getLocation();
					if (comp instanceof Container)
					{
						comp = getDeepestComponentAt(comp, x - loc.x, y - loc.y);
					}
					else
					{
						comp = comp.getComponentAt(x - loc.x, y - loc.y);
					}
					
					if (comp != null && comp.isVisible())
					{
						return comp;
					}
				}
			}
		}
		return parent;
	}
}
