/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/*
 * Author: Johannes Hermen Tudor/Santec
 * Mail: johannes.hermen@tudor.lu
 * Created: Feb 1, 2005
 *
 */
package lu.tudor.santec.gecamed.core.gui.utils;

import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;


/**
 * This Class provides a default ComboBoxRenderer for all Comboboxes in Gecam.
 * if you wan't to define a renderer for your own Objects, just implement this
 * one and overwrite the getRenderString(object) Method.
 *
 * @author Johannes Hermen johannes.hermen
 */
public class DefaultComboBoxRenderer extends JLabel implements ListCellRenderer
{
    //~ Static fields/initializers =============================================

    private static final long serialVersionUID = 1L;

    //~ Constructors ===========================================================
    /**
     * builds a new DefaultComboboxRenderer
     */
    public DefaultComboBoxRenderer()
    {
        setOpaque(true);
        setHorizontalAlignment(LEFT);
        setVerticalAlignment(CENTER);
    }

    //~ Methods ================================================================

    /*
     * (non-Javadoc)
     *
     * @see javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList,
     *      java.lang.Object, int, boolean, boolean)
     */
    public Component getListCellRendererComponent(JList list, Object value,
        int index, boolean isSelected, boolean cellHasFocus)
    {
        if (isSelected) {
            setBackground(list.getSelectionBackground());
            setForeground(list.getSelectionForeground());
        } else {
            setBackground(list.getBackground());
            setForeground(list.getForeground());
        }
        try {
            this.setEnabled(list.isEnabled());
        	this.setText(this.getRenderString(value));
            this.setToolTipText(this.getToolTipString(value));
        } catch (Exception e) {
            this.setText("");
            this.setToolTipText(null);
        }
        return this;
    }

    /**
     * This method retrieves the String to show in the combobox from the object
     * that is shown. Just implement this renderer and overwrite this method
     * to make the Combobox show what it should.
     *
     * @param o an Object shown in the Combobox
     *
     * @return the String that should be shown for this object.
     */
    protected String getRenderString(Object o)
    		{
        	return o.toString();
    		}

    protected String getToolTipString (Object o)
    		{
    		return null;
    		}
    
    public	String	renderObject (Object o)
    		{
    		return this.getRenderString(o);
    		}
}
