<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:template match="/">

<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">

<fo:layout-master-set>
	<fo:simple-page-master 
			master-name="A4" 
			page-height="297mm" 
			page-width="210mm" 
			margin="10mm">
		<fo:region-body 
				region-name="body" 
				margin="15mm" />
		<fo:region-before
				region-name="header" 
				extent="12mm" />
		<fo:region-after
				region-name="footer" 
				extent="12mm" />
	</fo:simple-page-master>
</fo:layout-master-set>

<fo:page-sequence master-reference="A4">
	<!-- HEADER -->
	<fo:static-content flow-name="header">
		<fo:block font-size="10">
			<fo:table>
				<fo:table-column column-width="70" />
				<fo:table-column />
				<fo:table-column column-width="70" />
				
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell />
						<fo:table-cell text-align="center">
							<fo:block><fo:page-number /> / <fo:page-number-citation ref-id="last-page"/></fo:block>
						</fo:table-cell>
						<fo:table-cell text-align="right">
							<fo:block><xsl:value-of select="gecamInfo/date"></xsl:value-of></fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
		</fo:block>
	</fo:static-content>
	
	<!-- BODY -->
	<fo:flow flow-name="body">
		<fo:block>
			<fo:block font-size="36" font-weight="bold" color="#AAAAAA" text-align="center"
					padding-top="10" padding-bottom="26">
				GECAMed Info:
			</fo:block>
			
			<!-- OFFICE INFO -->
			<fo:table>
				<fo:table-column column-width="50" />
				<fo:table-column />
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell>
							<fo:block font-weight="bold">Office:</fo:block>
						</fo:table-cell>
						<fo:table-cell>
							<fo:block>
								<xsl:value-of select="gecamInfo/office/name" />
							</fo:block>
							<xsl:for-each select="gecamInfo/office/address">
								<fo:block>
									<xsl:value-of select="." />
								</fo:block>
							</xsl:for-each>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
			
			<!-- CLIENT INFO -->
			<fo:block font-size="18" font-weight="bold" color="#555555" text-align="left"
					padding-top="20" padding-bottom="6" margin-left="12">
				Client Info
			</fo:block>
			<fo:block font-size="8">
				<fo:table>
					<fo:table-column column-width="50mm" />
					<fo:table-column />
					
					<fo:table-header>
						<fo:table-row>
							<fo:table-cell border-width="1" border-style="solid">
								<fo:block font-weight="bold">Property</fo:block>
							</fo:table-cell>
							<fo:table-cell border-width="1" border-style="solid">
								<fo:block font-weight="bold">Value</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-header>
					
					<fo:table-body>
						<xsl:for-each select="gecamInfo/clientInfo/info">
							<fo:table-row>
								<fo:table-cell border-style="solid">
									<fo:block wrap-option="wrap">
										<xsl:value-of select="@key"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell border-style="solid">
									<fo:block wrap-option="wrap">
										<xsl:value-of select="."></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:for-each>
					</fo:table-body>
				</fo:table>
			</fo:block>
			
			<!-- SERVER INFO -->
			<fo:block font-size="18" font-weight="bold" color="#555555" text-align="left"
					padding-top="20" padding-bottom="6" margin-left="12">
				Server Info
			</fo:block>
			<fo:block font-size="8">
				<fo:table>
					<fo:table-column column-width="60mm" />
					<fo:table-column />
					
					<fo:table-header>
						<fo:table-row>
							<fo:table-cell border-width="1" border-style="solid">
								<fo:block font-weight="bold">Property</fo:block>
							</fo:table-cell>
							<fo:table-cell border-width="1" border-style="solid">
								<fo:block font-weight="bold">Value</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-header>
					
					<fo:table-body>
						<xsl:for-each select="gecamInfo/serverInfo/info">
							<fo:table-row>
								<fo:table-cell border-width="1" border-style="solid">
									<fo:block>
										<xsl:value-of select="@key"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell border-width="1" border-style="solid">
									<fo:block>
										<xsl:value-of select="."></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:for-each>
					</fo:table-body>
				</fo:table>
			</fo:block>
			
			<!-- DATABASE INFO -->
			<fo:block font-size="18" font-weight="bold" color="#555555" text-align="left"
					padding-top="20" padding-bottom="6" margin-left="12">
				Database Info
			</fo:block>
			<fo:block font-size="8">
				<fo:table>
					<fo:table-column column-width="50mm" />
					<fo:table-column />
					
					<fo:table-header>
						<fo:table-row>
							<fo:table-cell border-width="1" border-style="solid">
								<fo:block font-weight="bold">Property</fo:block>
							</fo:table-cell>
							<fo:table-cell border-width="1" border-style="solid">
								<fo:block font-weight="bold">Value</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-header>
					
					<fo:table-body>
						<xsl:for-each select="gecamInfo/databaseInfo/info">
							<fo:table-row>
								<fo:table-cell border-style="solid">
									<fo:block wrap-option="wrap">
										<xsl:value-of select="@key"></xsl:value-of>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell border-style="solid">
									<fo:block wrap-option="wrap">
										<xsl:value-of select="."></xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:for-each>
					</fo:table-body>
				</fo:table>
			</fo:block>
		</fo:block>
		
		<fo:block id="last-page"/>
	</fo:flow>
</fo:page-sequence>

</fo:root>

</xsl:template>
</xsl:stylesheet>