/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.core.gui.plugin.filehandler;

import java.awt.event.ActionEvent;

import javax.swing.JOptionPane;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.GECAMedOptionPane;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.listener.AEntryAction;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;
import lu.tudor.santec.gecamed.patient.ejb.session.beans.IncidentManagerBean;
import lu.tudor.santec.gecamed.patient.ejb.session.interfaces.IncidentManager;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.i18n.Translatrix;

/**
 * @author martin.heinemann@tudor.lu
 * 09.04.2008
 * 08:00:36
 *
 *
 * @version
 * <br>$Log: DefaultEntryDeleteAction.java,v $
 * <br>Revision 1.11  2010-09-28 16:12:28  troth
 * <br>Complete - # 663: Accident entry can not be individually deleted from the history view.
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/663
 * <br>
 * <br>Revision 1.10  2010-09-20 13:38:37  troth
 * <br>add delete function on (right-click) history popupmenu for S.O.A.P. entries and measurements
 * <br>
 * <br>Revision 1.9  2010-06-14 13:53:23  troth
 * <br>Bug Fix - # 532: Abspeichern einer Verschreibung nach vorherigem Lschen unmglich
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/532
 * <br>
 * <br>Revision 1.8  2010-05-18 12:57:59  ferring
 * <br>unnecessary import removed
 * <br>
 * <br>Revision 1.7  2010-05-17 15:24:34  troth
 * <br>Incomplete - # 491: Inkonsistenter Zustand nach Lschen einer verschreibung
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/491
 * <br>
 * <br>Revision 1.6  2010-04-27 14:36:37  troth
 * <br>GECAMedOptionPane create now only a simple JOptionPane. May be later we build our own optionpane.
 * <br>
 * <br>Revision 1.5  2010-04-26 16:47:19  troth
 * <br>Redesign of the prescription view
 * <br>
 * <br>Revision 1.4  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-07-03 11:59:57  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2008-04-09 14:47:05  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2008-04-09 09:39:43  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class DefaultEntryDeleteAction extends AEntryAction {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private IncidentEntry entry2delete;

	private String dialogTitle;

	private String dialogQuestion;
 
	public DefaultEntryDeleteAction() {
		
		super(Translatrix.getTranslationString("plugin.file.delete"),
				GECAMedModule.getSmallIcon(GECAMedIconNames.CANCEL));
		
		this.dialogTitle = Translatrix.getTranslationString("plugin.file.delete");
		this.dialogQuestion = Translatrix.getTranslationString("plugin.file.delete.question");
	}
	
	/**
	 * constructor to label the delete-popupitem and to set the dialog title and question.
	 * 
	 * @param labelname the label of popupitem
	 * @param dialogTitle the title of the delete dialog
	 * @param dialogQuestion the question of the delete dialog
	 */
	public DefaultEntryDeleteAction(String labelname, String dialogTitle, String dialogQuestion) {
		
		super(labelname, GECAMedModule.getSmallIcon(GECAMedIconNames.CANCEL));
		
		this.dialogTitle = dialogTitle;
		this.dialogQuestion = dialogQuestion;
	}
	
	public void setEntry(IncidentEntry entry) {
		this.entry2delete = entry;
	}

	public void actionPerformed(ActionEvent e) {
				
		int reply = GECAMedOptionPane.showOptionDialog(
				MainFrame.getInstance(),
				dialogTitle,
				dialogQuestion,
				//"plugin.file.delete", "plugin.file.delete.question",
				JOptionPane.YES_NO_OPTION);
				//GECAMedOptionPane.ICON_QUESTION);
		
		if (reply == JOptionPane.YES_OPTION) {
			
			// delete the incident entry	
			try {
				
				IncidentManager iManager = (IncidentManager) ManagerFactory
				.getRemote(IncidentManagerBean.class);
				
				// incident entry is a measurement delete measurement values
				// TODO can be remove if patient.measurement DB have CONSTRAINT ON DELETE CASCADE
				// don't forget to remove incident entry from measurementValue list then
				if(IncidentManager.MEASUREMENT.equals(this.entry2delete.getEntryType().getName()))
				{
					iManager.deleteMeasurementValues(entry2delete.getIncidentId()); 	
				}
				
				iManager.removeIncidentEntry(entry2delete);
				
				// call all incidentEntryDeleted functions of all PatientViewTabs
				PatientManagerModule.getInstance().getPatientPanel().incidentEntryDeleted(entry2delete);
				
				PatientManagerModule.getInstance().getPatientPanel().reloadHistory();
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
	}
}
