/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: IFileHandler.java,v $
 * <br>Revision 1.3  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-03-20 16:08:14  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2007-12-17 14:59:59  heinemann
 * <br>plugins and file store and open
 * <br>
 *   
 */
package lu.tudor.santec.gecamed.core.gui.plugin;

import java.net.URL;
import java.util.List;
import java.util.Set;

import javax.swing.Action;

import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;

/**
 * A class that implements the IFileHandler interface can be used to handle any kind of files.
 * It must be specific for one or more mimetypes. If a file should be handled, 
 * all registered filehandlers with the matching mimetypes are called.
 * If no mimetype is matching, the system is doing a request on the supported file
 * extension. If after this action no filehandler feels to be responsible for a 
 * special file, the application is trying to transmit the file handling to the 
 * underlying operating system.
 * <p>
 * Each Handler must have at least a default action defined. Any further actions are displayed
 * in the appropriate place. e.G. in a mouse menu when the user is right-clicking on a file
 * in the medical history (anamnese).
 * 
 * @author martin.heinemann@tudor.lu
 * 30.11.2007
 * 11:08:44
 *
 *
 * @version
 * <br>$Log: IFileHandler.java,v $
 * <br>Revision 1.3  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-03-20 16:08:14  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2007-12-17 14:59:59  heinemann
 * <br>plugins and file store and open
 * <br>
 *   
 */
public interface IFileHandler  {
	
	
	/**
	 * Set the file to work with
	 * 
	 * @param fileUrl
	 */
	public void setFile(URL fileUrl);
	
	/**
	 * Set the binary data to work with
	 * 
	 * @param binaryData
	 */
	public void setFile(byte[] binaryData, String filename);
	
	/**
	 * This is the default action.
	 */
	public void defaultAction();
	
	/**
	 * Returns a list of all supplied actions, including the defaultaction
	 * @return
	 */
	public List<Action> getActions(IncidentEntry entry);
	
	/**
	 * Returns the mimetypes this handler is in charge of.
	 * @return
	 */
	public Set<String> getSupportedMimetypes();
	
	/**
	 * Returns a list of file extension this handler can handle. This is 
	 * a fall-back solution if no mimetype is matching for a handler.
	 * 
	 * @return
	 */
	public Set<String> getSupportedExtensions();
	
}
