/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: PhysicianListenerRegister.java,v $
 * <br>Revision 1.2  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2007-12-04 14:03:37  heinemann
 * <br>moved handling of the hotkeys from MainFrame to RegistrationDesk
 * <br>same with phycianlistener
 * <br>
 *   
 */
package lu.tudor.santec.gecamed.core.gui.listener;

import java.util.ArrayList;
import java.util.Collection;

import lu.tudor.santec.gecamed.core.gui.PhysicianListener;

/**
 * 
 * Static register class for PhysicianListeners.<br/>
 * Please use RegistrationDesk for registering and any further interaction.
 * 
 * @author martin.heinemann@tudor.lu
 * 04.12.2007
 * 14:47:35
 *
 *
 * @version
 * <br>$Log: PhysicianListenerRegister.java,v $
 * <br>Revision 1.2  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2007-12-04 14:03:37  heinemann
 * <br>moved handling of the hotkeys from MainFrame to RegistrationDesk
 * <br>same with phycianlistener
 * <br>
 *   
 */
public class PhysicianListenerRegister {
	
	/**
	 * Collection of listeners for physician events
	 */
	private static Collection<PhysicianListener> physicianListeners = new ArrayList<PhysicianListener>();
	
	
	
	
	private PhysicianListenerRegister() {
		/* ================================================== */

		/* ================================================== */
	}
	
	
	/**
	 * adds a physician listener
	 */
	public static void addPhysicianListener(PhysicianListener listener) {
		physicianListeners.add(listener);
	}

	/**
	 * removes a physician listener
	 */
	public static void removePhysicianListener(PhysicianListener listener) {
		physicianListeners.remove(listener);
	}

	
	
	/**
	 * Returns a collection of all physician listeners.
	 * If no one is registered, the collection will be empty, not null!
	 * 
	 * @return
	 */
	public static Collection<PhysicianListener> getAllListeners() {
		/* ================================================== */
		return physicianListeners;
		/* ================================================== */
	}
	
}
