/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: MessageListenerRegister.java,v $
 * <br>Revision 1.4  2008-12-08 09:15:23  hermen
 * <br>reloads user-list in physician admin tab if a new user is created
 * <br>
 * <br>Revision 1.3  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-04-08 09:52:33  heinemann
 * <br>moved creation of new calendar from OfficeBean to AgendaModule
 * <br>
 * <br>Revision 1.1  2007-12-04 14:32:30  heinemann
 * <br>moved registration of GECAMedMessageListener to RegistrationDesk
 * <br>
 *   
 */
package lu.tudor.santec.gecamed.core.gui.listener;

import java.util.ArrayList;
import java.util.Collection;

import lu.tudor.santec.gecamed.core.gui.GECAMedMessageListener;

/**
 * Static register for GECAMedMessageListener.<br/>
 * Use RegistrationDesk for register and any further interaction.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 04.12.2007
 * 15:05:32
 *
 *
 * @version
 * <br>$Log: MessageListenerRegister.java,v $
 * <br>Revision 1.4  2008-12-08 09:15:23  hermen
 * <br>reloads user-list in physician admin tab if a new user is created
 * <br>
 * <br>Revision 1.3  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-04-08 09:52:33  heinemann
 * <br>moved creation of new calendar from OfficeBean to AgendaModule
 * <br>
 * <br>Revision 1.1  2007-12-04 14:32:30  heinemann
 * <br>moved registration of GECAMedMessageListener to RegistrationDesk
 * <br>
 *   
 */
public class MessageListenerRegister {
	
	
	public static final String MESSAGE_CREATE_NEW_CALENDAR = "message_create_new_calendar";

	public static final String MESSAGE_USER_CHANGED = "message_user_changed";
	
	
	
	private static Collection<GECAMedMessageListener> gecamedMessageListeners = new ArrayList<GECAMedMessageListener>();

	
	private MessageListenerRegister() {
		/* ================================================== */

		/* ================================================== */
	}
	
	/**
	 * adds a GECAMedMessageListener which will receive all GECAMedMessages
	 * by calling his handleGECAMedMessage(GECAMedMessage message) method
	 */
	public static void addGECAMedMessageListener(GECAMedMessageListener listener) {
		gecamedMessageListeners.add(listener);
	}

	/**
	 * removes a GECAMedMessageListener
	 */
	public static void removeGECAMedMessageListener(GECAMedMessageListener listener) {
		gecamedMessageListeners.remove(listener);
	}
	
	
	/**
	 * Returns all listeners. Empty collection if noting has been registered
	 * 
	 * @return
	 */
	public static Collection<GECAMedMessageListener> getAllListener() {
		/* ================================================== */
		return gecamedMessageListeners;
		/* ================================================== */
	}
	
}
