/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.listener;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;

/**
 * An Action that can be used inside an IEntryTypeHandler.
 * It offers a setEntry method to the action to set
 * the current clicked incident entry to the action.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 01.07.2008
 * 10:18:27
 *
 *
 * @version
 * <br>$Log: AEntryAction.java,v $
 * <br>Revision 1.2  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2008-07-03 11:59:57  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
 public abstract class AEntryAction extends AbstractAction {
	 
	 
	 protected IncidentEntry entry2work = null;
	 
	 public AEntryAction(String text) {
		 /* ================================================== */
		 super(text);
		/* ================================================== */
	 }
	 
	 public AEntryAction(String text, ImageIcon icon) {
		 /* ================================================== */
		 super(text, icon);
		/* ================================================== */
	}

	/**
	  * Set the current IncidentEntry on which the action
	  * should work.
	  * 
	 * @param entry
	 */
	public void setEntry(IncidentEntry entry) {
		/* ================================================== */
		this.entry2work = entry;
		/* ================================================== */
	}
	 
}
