package lu.tudor.santec.gecamed.core.gui.launcher;

/**
 * The GECAMedLauncher server commands.
 * 
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: ServerCommand.java,v $
 * <br>Revision 1.2  2012-11-28 16:41:03  troth
 * <br>Version 1.3 of GECAMedLauncher and GECAMedLauncherServer 1.5.
 * <br>Some fixings in the LoginScreen.
 * <br>
 * <br>Revision 1.1  2012-10-19 16:24:42  troth
 * <br>First version of GECAMed launcher.
 * <br>
 */
public abstract class ServerCommand {
		
		protected String command;
		protected String description;

		public ServerCommand(String command, String description) {
			this.command = command;
			this.description = description;
		}

		public abstract String runCommand(String params) ;

		/**
		 * @return the command
		 */
		public String getCommand() {
			return command;
		}

		/**
		 * @param command the command to set
		 */
		public void setCommand(String command) {
			this.command = command;
		}

		/**
		 * @return the descriptrion
		 */
		public String getDescription() {
			return description;
		}

		/**
		 * @param descriptrion the descriptrion to set
		 */
		public void setDescription(String descriptrion) {
			this.description = descriptrion;
		}

		/* (non-Javadoc)
		 * @see java.lang.Object#toString()
		 */
		@Override
		public String toString() {
			return this.command + ": " + this.description;
		}
	}