/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.controller.document.word;

import lu.tudor.santec.gecamed.core.gui.controller.data.State;
import lu.tudor.santec.gecamed.core.gui.controller.document.DocumentController;

import com.jacob.com.Dispatch;
import com.jacob.com.Variant;

//Class for listening to events of word
public class WordListener
{
	private boolean		bQuit	= false;
	private State		state;
	private Dispatch	doc;
	private DocumentController controller;
	
	
	public WordListener(State state, Dispatch doc, DocumentController controller)
	{
		this.state 		= state;
		this.doc 		= doc;
		this.controller = controller;
	}
	
	
	public boolean isBQuit()
	{
		return bQuit;
	}
	
	
	public void DocumentBeforeSave(Variant[] args)
	{
		Dispatch words;
		int count;
		
		try
		{
			words = Dispatch.get(doc, "Words").toDispatch();
			if (words != null)
			{
				count = Dispatch.get(words, "Count").getInt();
				if (count > 0)
				{
					state.setSaved(true);
					controller.checkIfContainsContactInfo();
				}
			}
		}
		catch (Exception e)
		{
		}
		
	}
	
	
	public void Quit(Variant[] args)
	{
		bQuit = true;
	}
}
