/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.controller;

import java.io.File;
import java.util.HashMap;

import javax.swing.filechooser.FileFilter;

import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.controller.document.DocumentController;
import lu.tudor.santec.gecamed.core.gui.controller.document.word.WordController;
import lu.tudor.santec.gecamed.core.gui.controller.document.writer.WriterController;
import lu.tudor.santec.gecamed.core.gui.utils.SystemInfo;
import lu.tudor.santec.gecamed.core.gui.widgets.ErrorDialog;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialog;
import lu.tudor.santec.gecamed.core.utils.controller.utils.FileUtils;
import lu.tudor.santec.gecamed.letter.gui.LetterTemplateModule;
import lu.tudor.santec.gecamed.letter.gui.dialogs.WriterSelectDialog;
import lu.tudor.santec.gecamed.letter.gui.settings.LetterTemplateSettings;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import com.tetrasix.majix.uis.ExtensionFileFilter;

/*
 *PART THAT CONFIGURES TEH CONTROLLERS (hand in hand with the settingsplugin)
 */

public class ControllerConfig {
	
	/** the logger Object for this class */
	private static Logger logger = Logger.getLogger(ControllerConfig.class.getName());

	public static final String MIME_WORD = "letter/application/msword";

	public static final String MIME_WRITER = "letter/application/vnd.oasis.opendocument.text";

	public static final String MIME_LETTER = "content/unknown";

	private static final String ICON_LETTER = "letter.png";

	private static final String ICON_WORD = "word.png";
	
	private static final String ICON_WORD_OLD = "word_web.png";

	private static final String ICON_WRITER = "openoffice.png";
	
	private static final String ICON_WRITER_OLD = "openoffice_web.png";
	
	public static final String OO_INSTALLATION = "OO_INSTALLATION";

	public static HashMap<String, String> iconMapping = new HashMap<String, String>();

	private static String path;

	static {
		iconMapping.put(MIME_WORD, ICON_WORD);
		iconMapping.put(MIME_WRITER, ICON_WRITER);
		iconMapping.put(MIME_LETTER, ICON_LETTER);
		iconMapping.put(MIME_LETTER+"old", ICON_LETTER);
		iconMapping.put(MIME_WORD+"old", ICON_WORD_OLD);
		iconMapping.put(MIME_WRITER+"old", ICON_WRITER_OLD);
	}

	public static DocumentController getController(String tps, boolean allowOO) 
	{
		/* ------------------------------------------------------- */
		// Setting for now the drivers for windows and UNIX
		/* ------------------------------------------------------- */
		if (tps.equals(LetterTemplateSettings.WORD) && (SystemInfo.getOperatingSystem() == SystemInfo.SYSTEM_WINDOWS)) {
			try 
			{
				return new WordController();
			}
			catch (Throwable e) 
			{
				logger.log(Level.ERROR, "Couldn't load the WordController", e);
				
				// notify the user
				String message;
				if (e instanceof Error)
					 message = Translatrix.getTranslationString("ControllerConfig.CouldNotStartWord");
				else message = Translatrix.getTranslationString("ControllerConfig.CouldntOpenDocument");
				
				ErrorDialog.showErrorDialog(MainFrame.getInstance(), 
						Translatrix.getTranslationString("ControllerConfig.CouldntOpenDocumentTitle"), 
						message, e);
			}
		} else if (tps.equals(LetterTemplateSettings.WRITER) || allowOO) {
			/* ------------------------------------------------------- */
			// get the Writer path from the local client config
			/* ------------------------------------------------------- */
			String key = MainFrame.getMachineSetting(OO_INSTALLATION);
//			key = null;
			
			WriterController wControler = null;
			
			if (key != null && key != ""
					&& new File(key).exists()
					&& WriterController.validatePath(key))
			{
				path = key;
				wControler = new WriterController(path);
			}
			/* ------------------------------------------------------- */
			// if the controller is null, we must ask for a new installation path
			/* ------------------------------------------------------- */
			if (wControler == null) {
				/* ------------------------------------------------------- */
				// open the writer installation select dialiog
				/* ------------------------------------------------------- */
				WriterSelectDialog dialog = new WriterSelectDialog();
				dialog.showDialog();
				if (dialog.getButtonOption() == GECAMedBaseDialog.OK_OPTION)
				{
					try 
					{
						path = FileUtils.adeptInstallPath(dialog.getInstallationPath());
						wControler = new WriterController(path);
					} 
					catch (Exception e) {}
					/* ------------------------------------------------------- */
					// store the new path in the local config
					/* ------------------------------------------------------- */
					MainFrame.setMachineSetting(OO_INSTALLATION, path);
					/* ------------------------------------------------------- */
				}
			}
			return wControler;
		}
		return null;
	}

	public static boolean deleteDocuments() {
		return (Boolean) LetterTemplateModule.getInstance().getLetterSettings()
				.getValue(LetterTemplateSettings.DELETE);
	}

	public static String getLocalLetterPath() {
		String path = (String) LetterTemplateModule.getInstance()
				.getLetterSettings().getValue(
						LetterTemplateSettings.LETTER_LOCATION);
		if (path != "")
			return path;
		return null;
	}

	public static String getLocalTemplatePath() {
		String path = (String) LetterTemplateModule.getInstance()
				.getLetterSettings().getValue(
						LetterTemplateSettings.TEMPLATE_LOCATION);
		if (path != "")
			return path;
		return null;
	}

	public static FileFilter getExtensionFilter() {
//		String tps = (String) LetterTemplateModule.getInstance()
//				.getLetterSettings().getValue(LetterTemplateSettings.TPS);
//
//		if (tps.equals(LetterTemplateSettings.WORD))
//			return new ExtensionFileFilter(new String[] { "doc", "docx",
//					"dot", "dotx", "odt", "odf", "wps" });
//
//		if (tps.equalsIgnoreCase(LetterTemplateSettings.WRITER))
//			return new ExtensionFileFilter(new String[] { "doc", "docx",
//					"dot", "dotx", "odt", "odf", "wps" });
//
//		return new ExtensionFileFilter();
		
		return new ExtensionFileFilter(new String[] { "doc", "docx", "dot", "dotx", "odt", "odf", "wps" });
	}
}
