/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: RegistrationDesk.java,v $
 * <br>Revision 1.7  2011-03-04 09:53:11  ferring
 * <br>Hotkeys for physicians added.
 * <br>It is now possible to make a hotkey consisting of key + modifiers.
 * <br>
 * <br>Revision 1.6  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-03-06 15:34:26  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4  2007-12-04 14:32:30  heinemann
 * <br>moved registration of GECAMedMessageListener to RegistrationDesk
 * <br>
 * <br>Revision 1.3  2007-12-04 14:03:37  heinemann
 * <br>moved handling of the hotkeys from MainFrame to RegistrationDesk
 * <br>same with phycianlistener
 * <br>
 * <br>Revision 1.2  2007-12-03 10:59:02  hermen
 * <br>updated Javadoc
 * <br>
 * <br>Revision 1.1  2007-11-30 14:25:05  heinemann
 * <br>moved handling of the hotkeys from MainFrame to RegistrationDesk
 * <br>
 *   
 */
package lu.tudor.santec.gecamed.core.gui;

import java.util.Collection;
import java.util.Set;

import javax.swing.AbstractAction;

import lu.tudor.santec.gecamed.core.gui.listener.EntryTypeRegister;
import lu.tudor.santec.gecamed.core.gui.listener.GlobalHotkeyRegister;
import lu.tudor.santec.gecamed.core.gui.listener.IEntryTypeHandler;
import lu.tudor.santec.gecamed.core.gui.listener.MessageListenerRegister;
import lu.tudor.santec.gecamed.core.gui.listener.PhysicianListenerRegister;

/**
 * Class to register several stuff. HotKeys, Plugins, etc.<br/>
 * All information are stored in static collections, hashmaps,etc.
 * 
 * @author martin.heinemann@tudor.lu
 * 30.11.2007
 * 11:24:06
 *
 *
 * @version
 * <br>$Log: RegistrationDesk.java,v $
 * <br>Revision 1.7  2011-03-04 09:53:11  ferring
 * <br>Hotkeys for physicians added.
 * <br>It is now possible to make a hotkey consisting of key + modifiers.
 * <br>
 * <br>Revision 1.6  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-03-06 15:34:26  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4  2007-12-04 14:32:30  heinemann
 * <br>moved registration of GECAMedMessageListener to RegistrationDesk
 * <br>
 * <br>Revision 1.3  2007-12-04 14:03:37  heinemann
 * <br>moved handling of the hotkeys from MainFrame to RegistrationDesk
 * <br>same with phycianlistener
 * <br>
 * <br>Revision 1.2  2007-12-03 10:59:02  hermen
 * <br>updated Javadoc
 * <br>
 * <br>Revision 1.1  2007-11-30 14:25:05  heinemann
 * <br>moved handling of the hotkeys from MainFrame to RegistrationDesk
 * <br>
 *   
 */
public class RegistrationDesk {
	
	private RegistrationDesk() {
		/* ================================================== */

		/* ================================================== */
	}
	
	
	
	/* **********************************************************************************
	 *                       H O T K E Y   S E C T I O N
	 * 
	 * ******************************************************************************** */
	
	/**
	 * Register a system wide hotkey
	 * 
	 * @param key
	 * @param action
	 * @return
	 */
	public static boolean registerHotKey(String key, AbstractAction action) {
		/* ================================================== */
		return GlobalHotkeyRegister.registerHotKey(key, action);
		/* ================================================== */
	}
	

	public static boolean registerHotKey(int key, AbstractAction action)
	{
		return registerHotKey(GlobalHotkeyRegister.getKeyString(key, 0), action);
	}
	
	
	public static boolean registerHotKey(int key, int modifiers, AbstractAction action)
	{
		return registerHotKey(GlobalHotkeyRegister.getKeyString(key, modifiers), action);
	}


	public static AbstractAction getHotKey(int key) 
	{
		return GlobalHotkeyRegister.getHotKey(GlobalHotkeyRegister.getKeyString(key, 0));
	}
	
	
	/**
	 * Return an action for a key code
	 * @param i
	 * @return
	 */
	public static AbstractAction getHotKey(String key) {
		/* ====================================================== */
		return GlobalHotkeyRegister.getHotKey(key);
		/* ====================================================== */
	}
	

	/**
	 * Unregister Hotkey
	 * 
	 * @param i
	 * @return
	 */
	public static boolean unregisterHotKey(String key) {
		/* ====================================================== */
		return GlobalHotkeyRegister.unregisterHotKey(key);
		/* ====================================================== */
	}

	public static boolean unregisterHotKey(int key, int modifiers) {
		/* ====================================================== */
		return GlobalHotkeyRegister.unregisterHotKey(GlobalHotkeyRegister.getKeyString(key, modifiers));
		/* ====================================================== */
	}

	public static boolean unregisterHotKey(int key) {
		/* ====================================================== */
		return GlobalHotkeyRegister.unregisterHotKey(GlobalHotkeyRegister.getKeyString(key, 0));
		/* ====================================================== */
	}
	
	public static Set<String> getHotKeyKeys() {
		/* ================================================== */
		return GlobalHotkeyRegister.getHotKeyKeys();
		/* ================================================== */
	}


	public static Collection<AbstractAction> getAllHotKeyActions() {
		/* ====================================================== */
		return GlobalHotkeyRegister.getAllHotKeyActions();
		/* ====================================================== */
	}
	
	
	/* **********************************************************************************
	 *                       P H Y S I C I A N   S E C T I O N
	 * 
	 * ******************************************************************************** */
	
	/**
	 * adds a physician listener
	 */
	public static void addPhysicianListener(PhysicianListener listener) {
		PhysicianListenerRegister.addPhysicianListener(listener);
	}

	/**
	 * removes a physician listener
	 */
	public static void removePhysicianListener(PhysicianListener listener) {
		PhysicianListenerRegister.removePhysicianListener(listener);
	}



	
	
	/* **********************************************************************************
	 *         G E C A M e d M E S S A G E L I S T E N E R    S E C T I O N
	 * 
	 * ******************************************************************************** */
	
	
	/**
	 * adds a GECAMedMessageListener which will receive all GECAMedMessages
	 * by calling his handleGECAMedMessage(GECAMedMessage message) method
	 */
	public static void addGECAMedMessageListener(GECAMedMessageListener listener) {
		MessageListenerRegister.addGECAMedMessageListener(listener);
	}

	/**
	 * @return
	 */
	public static Collection<GECAMedMessageListener> getAllMessageListener() {
		/* ====================================================== */
		return MessageListenerRegister.getAllListener();
		/* ====================================================== */
	}
	
	
	/* ***************************************************************************
	 *          E N T R Y T Y P E   H A N D L E R
	 *          
	 * ************************************************************************* */
	
	public static void addEntryTypeHandler(String name, IEntryTypeHandler handler) {
		/* ================================================== */
		EntryTypeRegister.registerHandler(name, handler);
		/* ================================================== */
	}
}
