/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui;

import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;

/**
 * Listener for classes that want to be notified if the current patient changes.
 * Register at GECAMedModule
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 * 
 * @Version
 * <br>$Log: PatientListener.java,v $
 * <br>Revision 1.6  2009-01-26 13:21:32  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.5  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-01-15 09:29:39  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.3  2007-12-03 10:59:02  hermen
 * <br>updated Javadoc
 * <br>
 *
 */
public interface PatientListener {
	
	/**
	 * called if the current patient is changed.
	 * 
	 * @param patient the new selected Patient
	 */
	public abstract void patientChanged(Patient patient);
}
