/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui;


/**
 * static class that defines the icons used in the GECAMed client.
 * these are only the global icons, each module should define its 
 * own used icons
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 * 
 * @Version
 * <br>$Log: GECAMedIconNames.java,v $
 * <br>Revision 1.59  2013-11-22 13:51:10  troth
 * <br>Fix some small bugs in the consultation view.
 * <br>Add new gui function the patient setting to config the consultation view.
 * <br>
 * <br>Revision 1.58  2013-02-08 15:27:17  ferring
 * <br>Option added for files and letters to attach them to another incident
 * <br>
 * <br>Revision 1.57  2013-01-15 11:50:53  troth
 * <br>Add scanner function for mac os. (Testversion)
 * <br>
 * <br>Revision 1.56  2012-06-04 06:03:01  ferring
 * <br>file overview added in tools
 * <br>
 * <br>Revision 1.55  2011-09-02 13:06:32  ferring
 * <br>Auto completion ex- and import added
 * <br>
 * <br>Revision 1.54  2011-02-01 13:05:45  ferring
 * <br>sorted
 * <br>
 * <br>Revision 1.53  2010-05-05 14:19:54  ferring
 * <br>newFormButton added
 * <br>
 * <br>Revision 1.52  2010-04-21 09:41:59  hermen
 * <br>small bugfixes
 * <br>
 * <br>Revision 1.51  2010-03-24 16:41:24  hermen
 * <br>changed remove icon
 * <br>
 * <br>Revision 1.50  2010-03-23 15:01:02  troth
 * <br>add icons for redesign of the patient view history
 * <br>
 * <br>Revision 1.49  2010-03-12 14:17:42  hermen
 * <br>cleanup of panel layouts and icons
 * <br>
 * <br>Revision 1.48  2010-02-18 16:47:02  troth
 * <br>add scanner icons for document scan
 * <br>
 * <br>Revision 1.47  2010-02-09 13:32:46  troth
 * <br>added message icons for usermessages
 * <br>
 * <br>Revision 1.46  2008-12-05 15:13:08  hermen
 * <br>added menue entry for online manual and fixed printing of addressbook entries
 * <br>
 * <br>Revision 1.45  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.44  2008-07-04 13:02:04  heinemann
 * <br>complete - # 159: Add notes to entries of the waitingroom
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/159
 * <br>
 * <br>Revision 1.43  2008-05-06 07:54:08  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.42  2008-04-07 16:54:05  mack
 * <br>Added Physician icon to core
 * <br>
 * <br>Revision 1.41  2008-03-26 13:46:26  hermen
 * <br>added backupdb menu entry
 * <br>
 * <br>Revision 1.40  2008-03-11 17:17:11  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.39  2008-03-10 13:49:29  hermen
 * <br>updated splash and about screen
 * <br>
 * <br>Revision 1.38  2008-03-06 08:30:33  hermen
 * <br>new SplashScreen
 * <br>
 * <br>Revision 1.37  2008-02-11 16:46:49  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.36  2008-01-28 08:28:06  hermen
 * <br>moved functionality to IconFetcher Class and GECAMedIconNames Interface
 * <br>
 * <br>Revision 1.35  2008-01-21 16:23:26  heinemann
 * <br>added icons from IconBuilder
 * <br>
 * <br>Revision 1.34  2008-01-15 09:29:39  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.33  2008-01-02 09:40:30  heinemann
 * <br>enhanced logo in loginscreen
 * <br>
 * <br>Revision 1.32  2007-12-03 10:59:02  hermen
 * <br>updated Javadoc
 * <br>
 *
 */
public interface GECAMedIconNames
{
    //~ Static fields/initializers =============================================

//	***************************************************************************
//	* Class Constants			                                              *
//	***************************************************************************

	public static final int LARGEPIX 	= 64;
	public static final int NORMALPIX 	= 32;
	public static final int MEDIPIX 	= 24;
	public static final int SMALLPIX 	= 18;
	public static final int MINIPIX 	= 16;
	
	public static final String SPLASHSCREEN = "SplashScreen.png";
	public static final String HELPSCREEN 	= "GECAMed_Help.png";
    public static final String LOGO 		= "logo.png";
    public static final String LOGO_BIG 	= "logo_big.png";
    public static final String LOGO_WEB20 	= "GECAmedWeb2.0.png";
    public static final String REDCROSS 	= "icon.png";
    public static final String MODULES 		= "modules.png";

    // CHECKED ----------------------------------------------------------------------

    public static final String SAVE 		= "save.png";
    public static final String OPEN 		= "open.png";

    public static final String IMPORT		= "import.png";
    public static final String EXPORT		= "export.png";
    
    public static final String TEMPLATE 			= "template.png";
    public static final String TEMPLATE_SAVE 		= "template_save.png";
    public static final String TEMPLATE_ADD 		= "template_add.png";
    public static final String TEMPLATE_OPEN 		= "template_open.png";
    public static final String TEMPLATE_DELETE      = "template_delete.png";
    
    public static final String SEARCH 		= "search.png";
    
    public static final String CUT 			= "cut.png";
    public static final String COPY 		= "copy.png";
    public static final String PASTE 		= "paste.png";
    public static final String CALCULATOR	= "calc.png";

    
    public static final String UP 			= "up.png";
    public static final String DOWN			= "down.png";
    public static final String LEFT 		= "left.png";
    public static final String RIGHT 		= "right.png";
    
    public static final String ADD 			= "add.png";
    public static final String REMOVE 		= "remove.png";
    
    public static final String ADD_LINE 	= "add_line.png";
    public static final String REMOVE_LINE 	= "remove_line.png";
    
    public static final String ENTRY_PUBLIC = "entry_public.png";
    public static final String ENTRY_PRIVATE= "entry_private.png";
    
    public static final String RENAME 		= "rename.png";
    
    public static final String LOG 			= "log.png";
    
    public static final String EMPTY_ICON 	= "empty_32.png";
    // NOT CHECKED ----------------------------------------------------------------------        
        


    public static final String CHANGE_FOLDER	= "change_folder.png";
    public static final String EXIT 			= "exit.png";
    public static final String ERROR 			= "error.png";
    public static final String URGENT 			= "urgent.png";
    public static final String PASSWORD 		= "password.png";
    public static final String SETTINGS 		= "exec.png";
    public static final String CLOSE 			= "close.png";
    public static final String HELP 			= "help.png";
    public static final String INFO 			= "info.png";
    public static final String WARNING 			= "warning.png";
    public static final String SERVER 			= "server.png";
    public static final String EMAIL 			= "email.png";
    public static final String MESSAGE 			= "message.png";
    public static final String MESSAGE_GREY 	= "message_grey.png";
    public static final String MESSAGE_NEW 		= "message_new.png";
    public static final String MESSAGE_BLINK 	= "message_blink.gif";
    public static final String MESSAGE_DELETE 	= "message_delete.png";
    public static final String SCRIPT			= "script.png";

    
    public static final String BACK 			= "previous.png";
    public static final String FORWARD 			= "next.png";

    public static final String EDIT 			= "edit.png";
    public static final String LOCK 			= "lock.png";
    public static final String CLOCK 			= "clock.png";
    public static final String UNDO 			= "button_undo.png";
    public static final String DO	 			= "button_do.png";
    public static final String OK 				= "button_ok.png";
    public static final String CANCEL 			= "button_cancel.png";
    public static final String NO 				= "button_no.png";
    public static final String RUNNING			= "button_running.png";
    public static final String BUG 				= "bug.png";
    public static final String HOTKEYS 			= "hotkeys.png";
    
    public static final String LOCKED 			= "locked.png";

    public static final String MEMO 			= "memo.png";
    public static final String MEMO_EMPTY 		= "memo_empty.png";
    public static final String MEMO_BLINK 		= "memo_blink.gif";

	public static final String OFFICE 			= "office.png";
	public static final String PHYSICIAN 		= "physician.png";
	public static final String PHYSICIAN_NO 	= "nophysician.png";
	public static final String CURSOR_PILL 		= "cursor_pill.gif";
	public static final String RELOAD 			= "reload.png";

	public static final String FILTER 			= "filter.png";

	public static final String STOP_LEFT 		= "stop_left.png";
	public static final String STOP_RIGHT 		= "stop_right.png";

	public static final String PRINT  			= "print.png";
	public static final String PRINT_1  		= "print1.png";
	public static final String PRINT_ALL  		= "printall.png";

	public static final String XRAY 			= "xray.png";

	public static final String JCONSOLE 		= "jconsole.png";

	public static final String ZOOMOUT 			= "zoom-.png";
	public static final String ZOOMIN 			= "zoom+.png";
	public static final String ZOOMMAX 			= "zoommax.png";
	public static final String ZOOM1_1 			= "zoom1.png";
	
	public static final String PRINT_CERTIFICATE= "";
	public static final String BLUE_LIGHT 		= "accident_blink.gif";
	
	public static final String BACKUP_DB 		= "dbbackup.png";
	
	public static final String SCAN_JPG			= "scan_jpg.png";
	public static final String SCAN_PNG			= "scan_png.png";
	public static final String SCAN_PDF			= "scan_pdf.png";
	public static final String SCAN				= "scan.png";
	
	//  html editor
    public static final String EDIT_CUT 		= "editcut.png";
    public static final String EDIT_COPY 		= "editcopy.png";
    public static final String EDIT_PASTE 		= "editpaste.png";
    public static final String TEXT_BOLD 		= "text_bold.png";
    public static final String TEXT_ITALIC 		= "text_italic.png";
    public static final String TEXT_UNDER 		= "text_under.png";
    public static final String TEXT_LEFT 		= "text_left.png";
    public static final String TEXT_RIGHT 		= "text_right.png";
    public static final String TEXT_CENTER 		= "text_center.png";
	
    public static final String EDIT_CLEAR_LTR   = "edit-clear-ltr.png";
    public static final String EDIT_CLEAR_RTL   = "edit-clear-rtl.png";
    
    public static final String MANUAL 			= "manual.png";
    public static final String FILE				= "file_doc.png";
    
}

