/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui;

import java.awt.Font;

import javax.swing.JLabel;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

/**
 * 
 * static class that defines the fonts used in the GECAMed client.
 *
 * @Version
 * <br>$Log: GECAMedFonts.java,v $
 * <br>Revision 1.6  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-04-16 14:24:28  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4  2008-01-15 09:29:39  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.3  2007-12-03 10:59:02  hermen
 * <br>updated Javadoc
 * <br>
 *
 */
public class GECAMedFonts 
{
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	public static final Font BUTTON_FONT = new Font("Arial", Font.BOLD, 9);
	public static final Font TEXTFIELD_FONT = new Font("Arial", Font.PLAIN, 12);
	
	
	public static Font PLAIN_LABEL_FONT = null;
	public static Font BOLD_LABEL_FONT = null;
	
	
	static {
		JLabel tempLabel = new JLabel();
		PLAIN_LABEL_FONT = new Font(tempLabel.getFont().getName(),Font.PLAIN, tempLabel.getFont().getSize());
		BOLD_LABEL_FONT = new Font(tempLabel.getFont().getName(),Font.BOLD, tempLabel.getFont().getSize());
	}
	
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
	
}
