/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.ejb.session.beans;

import java.util.Collection;

import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.NationalHoliday;
import lu.tudor.santec.gecamed.core.ejb.session.interfaces.NationalHolidayInterface;

//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************

/**
 * 	This SessionBean class manages the getter access to the national holiday list.
 * 
 * @author nmac
 * 
 * @Version
 * <br>$Log$
 * <br>Revision 1.4  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-15 10:44:12  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 */
@Stateless
@Remote (NationalHolidayInterface.class)
public class NationalHolidayBean implements NationalHolidayInterface
	{
	private static final long serialVersionUID = 1L;
	
	@PersistenceContext (unitName="gecam")
	EntityManager m_EntityManager;

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************

/* (non-Javadoc)
 * @see lu.tudor.santec.gecamed.core.ejb.session.interfaces.NationalHolidayInterface#getAllNationalHolidays()
 */
public Collection <NationalHoliday> getAllNationalHolidays () throws Exception 
	{
	Collection <NationalHoliday> l_NationalHolidays;
	
	l_NationalHolidays = m_EntityManager.createNamedQuery ("getAllNationalHolidays").getResultList();
	return l_NationalHolidays;
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
	}
