/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.ejb.session.beans;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

import javax.ejb.Stateful;

import lu.tudor.santec.gecamed.core.ejb.session.interfaces.ChunkedFileManager;
import lu.tudor.santec.gecamed.core.utils.FileUtils;

/**
 * @author martin.heinemann@tudor.lu
 * 24.07.2008
 * 13:55:54
 *
 *
 * @version
 * <br>$Log: ChunkedFileManagerBean.java,v $
 * <br>Revision 1.3  2012-03-15 08:07:50  ferring
 * <br>TimeTracker removed
 * <br>
 * <br>Revision 1.2  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2008-07-25 14:42:42  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
@Stateful
public class ChunkedFileManagerBean implements ChunkedFileManager {

	
	
    private String  filename    = null;
    private String  newFilename = null;
    
    private FileOutputStream     fout;
    private BufferedOutputStream buffOut;
    
    
    
    
    /* (non-Javadoc)
     * @see lu.tudor.santec.gecamed.core.ejb.session.interfaces.ChunkedFileManager#createFile(java.lang.String)
     */
    public void createFile(String name) throws Exception {
        /* ====================================================== */
        createFile(null, name);
        /* ====================================================== */
    }
    
    /**
     * @throws Exception 
	 * 
	 */
	public void createFile(Integer patientId, String name) throws Exception {
        /* ====================================================== */
//	    TimeTracker.start("SAVE");
        this.filename  = name;
        /* ------------------------------------------------------- */
        File file = null;
        if (patientId != null)
            file = FileUtils.createPatientFile(patientId, filename);
        else
            file = FileUtils.createTempFile(name);
        /* ------------------------------------------------------- */
        // create the file
        /* ------------------------------------------------------- */
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        this.newFilename = file.getAbsolutePath();
        /* ------------------------------------------------------- */
        // create a buffered OutputStream for writing
        this.fout = new FileOutputStream(file);
        this.buffOut = new BufferedOutputStream(fout);
//        TimeTracker.lapTime("SAVE", "Statefull Session successfully initialized for recieving binary data");
//        TimeTracker.lapTime("SAVE", name);
        /* ====================================================== */
    }

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.ejb.session.interfaces.ChunkedFileManager#recieve(byte[])
	 */
	public void recieve(byte[] b) throws IOException {
		/* ====================================================== */
//	    TimeTracker.lapTime("SAVE", "start recieving bytes");
		buffOut.write(b);
//		TimeTracker.lapTime("SAVE", "finish recieving bytes");
		/* ====================================================== */
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.ejb.session.interfaces.ChunkedFileManager#closeFile()
	 */
	public String closeFile() {
		/* ====================================================== */
//	    TimeTracker.finish("SAVE");
	    try {
            fout.close();
            return newFilename;
        } catch (IOException e) {
            /* --------------------------------------------- */
            e.printStackTrace();
            return null;
            /* --------------------------------------------- */
        }
		/* ====================================================== */
	}
}
