/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * 
 */
package lu.tudor.santec.gecamed.core.ejb.entity.beans.log;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;


/**
 * The entity to store and read log messages
 * 
 * @author martin.heinemann@tudor.lu
 *
 *
 * @version
 * <br>$Log: Log.java,v $
 * <br>Revision 1.7  2010-04-08 10:56:40  hermen
 * <br>enhanced logging
 * <br>
 * <br>Revision 1.6  2009-05-29 13:51:21  hermen
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.5  2009-05-29 09:15:25  hermen
 * <br>added export to log view
 * <br>
 * <br>Revision 1.4  2008-09-25 09:43:08  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2006/11/22 13:00:08  heinemann
 * <br>fixed package name
 * <br>
 * <br>Revision 1.2  2006/10/25 11:17:15  heinemann
 * <br>improved logging
 * <br>
 * <br>Revision 1.1  2006/10/24 09:18:22  heinemann
 * <br>New Beans for the logging
 * <br>
 */
@Entity
@Table(name="log", schema="core")
public class Log extends GECAMedEntityBean implements Serializable {

	private static final long serialVersionUID = 1L;

	/* ********************************************************************** */
	/*                  Class Members										  */
	/* ---------------------------------------------------------------------- */
	
	public static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	
	/**
	 * The timestamp, when the action was logged
	 */
	private Date time;
	
	/**
	 * The user's id who was the trigger of this log message
	 */
	private Integer userId;
	
	/**
	 * The users name
	 */
	private String userName;
	
	/**
	 * The type of a log entry. Referenced by LogType.
	 */
	private Integer typeId;
	
	/**
	 * The operation, that triggers this log msg
	 */
	private String operation;
	
	/**
	 * The module that created this entry
	 */
	private String module;
	
	/**
	 * The description of the log entry
	 */
	private String text;
	
	/**
	 * The host name and ip address of the client
	 */
	private String host;
	
	/**
	 * The site name of the client
	 */
	private String site;
	
	/**
	 * The duration of the action
	 */
	private Long duration;
	
	/* --------------------------------------------------------------------------- */
	/*                          End of Class Members                               */
	/* *************************************************************************** */
	
	/**
	 * 
	 */
	public Log() {
		super();
	}

	/**
	 * @param time 
	 * @param userId
	 * @param userName
	 * @param typeId
	 * @param operation
	 * @param module
	 * @param text
	 */
	public Log(Date time, Integer userId, String userName, Integer typeId, String operation, String module, String text) {
		super();
		this.time = time;
		this.userId = userId;
		this.userName = userName;
		this.typeId = typeId;
		this.operation = operation;
		this.module = module;
		this.text = text;
	}
	
	/**
	 * @param typeId
	 * @param operation
	 * @param module
	 * @param text
	 */
	public Log(Integer typeId, String operation, String module, String text, long duration) {
		super();
		this.typeId = typeId;
		this.operation = operation;
		this.module = module;
		this.text = text;
		this.duration = duration;
	}
	
	
	/* ****************************************************************************** */
	/*                               Getter and Setter                                */
	/* ------------------------------------------------------------------------------ */

	/* ----------------------------------------------------------------------- */
	/*                        Start of Getters								   */
	
	/**
	 * @return
	 */
	@Column(name="module")
	public String getModule() {
		return module;
	}
	/**
	 * @return
	 */
	@Column(name="operation")
	public String getOperation() {
		return operation;
	}

	/**
	 * @return
	 */
	@Column(name="text")
	public String getText() {
		return text;
	}

	/**
	 * @return
	 */
	@Column(name="time")
	public Date getTime() {
		return time;
	}
	/**
	 * @return
	 */
	@Column(name="type_id")
	public Integer getTypeId() {
		return typeId;
	}
	/**
	 * @return
	 */
	@Column(name="user_id")
	public Integer getUserId() {
		return userId;
	}
	/**
	 * @return
	 */
	@Column(name="username")
	public String getUserName() {
		return userName;
	}
	
	/**
	 * @return the host
	 */
	@Column(name="host")
	public String getHost() {
		return host;
	}


	@Column(name="site")
	public String getSite() {
	    return site;
	}

	@Column(name="duration")
	public Long getDuration() {
	    return duration;
	}
	
	/*                     End of Getters                  					   */
	/* ----------------------------------------------------------------------- */
	
	/* ----------------------------------------------------------------------- */
	/*                        Start of Setters								   */
	
	public void setModule(String module) {
		this.module = module;
	}

	public void setOperation(String operation) {
		this.operation = operation;
	}

	public void setText(String text) {
		this.text = text;
	}

	public void setTime(Date time) {
		this.time = time;
	}

	public void setTypeId(Integer typeId) {
		this.typeId = typeId;
	}

	public void setUserId(Integer userId) {
		this.userId = userId;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	/**
	 * @param host the host to set
	 */
	public void setHost(String host) {
		this.host = host;
	}
	
	public void setSite(String site) {
	    this.site = site;
	}

	public void setDuration(Long duration) {
	    this.duration = duration;
	}
	
	
	/*                     End of Setters                  					   */
	/* ----------------------------------------------------------------------- */
	/*                      End of Getters and Setters                         */
	/* *********************************************************************** */
	
	@Transient
	public String[] toStringArr() {
	    String[] arr = new String[9]; 
	    arr[0] = getType();
	    arr[1] = dateFormat.format(getTime());		
	    arr[2] = getUserName();
	    arr[3] = getModule();
	    arr[4] = getOperation();
	    arr[5] = getText();
	    arr[6] = getHost();
	    arr[7] = getSite();
	    arr[8] = getDuration()+"";
	    return arr;
	}

	@Transient
	private String getType() {
	    switch (getTypeId()) {
	    case LogType.ADMIN:
		return "Admin";
	    case LogType.SYSTEM:
		return "System";
	    case LogType.USER:
		return "User";
	    default:
		return "";
	    }
	}


	
}
