package lu.tudor.santec.gecamed.core.ejb.entity.beans;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;




/**
 * @author ferring
 *
 */

@NamedQueries({
	@NamedQuery(name = XSLTemplate.GET_TEMPLATES_FOR_OFFICE, 
			query = "SELECT OBJECT(o) FROM XSLTemplate o" +
					" WHERE o.referenceType = :referenceType" +
					" AND o.referenceId = :referenceId" +
					" AND o.physicianId is null" +
					" ORDER BY o.name"),
	@NamedQuery(name = XSLTemplate.GET_TEMPLATES_FOR_PHYSICIAN, 
			query = "SELECT OBJECT(o) FROM XSLTemplate o" +
					" WHERE o.referenceType = :referenceType" +
					" AND o.referenceId = :referenceId" +
					" AND (" +
					" 		o.physicianId is null" +
					" 	OR 	o.physicianId = :physicianId)" +
					" ORDER BY o.name")
})

@Entity
@Table(name = "xsl_templates", schema = "core")
public class XSLTemplate extends GECAMedEntityBean 
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long serialVersionUID = 1L;
	
	private static final String EXTENSION_REGEX = "\\.[^\\.]+$";
	
	
	public static final String GET_TEMPLATES_FOR_PHYSICIAN 	= "getXSLTemplatesForPhysician";
	public static final String GET_TEMPLATES_FOR_OFFICE 	= "getXSLTemplatesForOffice";

	
	public static final String TYPE_FORM_EDITOR = "formeditor";
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private String 	name;
	private String 	data;
	private Boolean useForHistory;
	private Boolean useToEdit;
	private Boolean useToPrint;
	private String 	referenceType;
	private Integer referenceId;
	private Integer physicianId;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public XSLTemplate ()
	{
		name 			= "";
		data 			= null;
		physicianId 	= null;
		
		useForHistory 	= Boolean.FALSE;
		useToEdit 		= Boolean.FALSE;
		useToPrint 		= Boolean.FALSE;
	}
	
	
	@Column(name = "reference_type")
	public String getReferenceType()
	{
		return referenceType;
	}
	
	
	public void setReferenceType(String type)
	{
		this.referenceType = type;
	}


	@Column(name = "reference_id")
	public Integer getReferenceId()
	{
		return referenceId;
	}


	public void setReferenceId(Integer referenceId)
	{
		this.referenceId = referenceId;
	}
	

	@Column(name = "name")
	public String getName()
	{
		return name;
	}
	
	
	public void setName(String name)
	{
		this.name = name;
	}
	

	@Column(name = "physician_id")
	public Integer getPhysicianId()
	{
		return physicianId;
	}
	
	
	public void setPhysicianId(Integer physicianId)
	{
		this.physicianId = physicianId;
	}
	

	@Column(name = "data")
	public String getData()
	{
		return data;
	}
	
	
	public void setData(String data)
	{
		this.data = data;
	}
	

	@Column(name = "use_for_history")
	public Boolean getUseForHistory()
	{
		return useForHistory == null ? Boolean.FALSE : useForHistory;
	}
	
	
	public void setUseForHistory(Boolean useForHistory)
	{
		this.useForHistory = useForHistory;
	}
	

	@Column(name = "use_to_edit")
	public Boolean getUseToEdit()
	{
		return useToEdit == null ? Boolean.FALSE : useToEdit;
	}
	
	
	public void setUseToEdit(Boolean useToEdit)
	{
		this.useToEdit = useToEdit;
	}
	

	@Column(name = "use_to_print")
	public Boolean getUseToPrint()
	{
		return useToPrint == null ? Boolean.FALSE : useToPrint;
	}
	
	
	public void setUseToPrint(Boolean useToPrint)
	{
		this.useToPrint = useToPrint;
	}
	
	
	@Transient
	public int compareTo(GECAMedEntityBean o)
	{
		if (o != null && o instanceof XSLTemplate)
			return name.compareTo(((XSLTemplate)o).name);
		else
			return super.compareTo(o);
	}
	
	
	@Transient
	public String getFileNamePrefix ()
	{
		return name.replaceAll(EXTENSION_REGEX, "");
	}
	
	
	@Transient
	public String getFileNameExtension ()
	{
//		String extension = "html";
//		if (!useForHistory.booleanValue() && name.contains("."))
		String extension = name.replace(getFileNamePrefix()+".", "");
		
		return extension;
	}
}
