/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 * @author Johannes Hermen johannes.hermen(at)tudor.luc
 * 
 * Entity Bean that maps the <b>core.templates</b> table
 * which stores a list of all available printing templates as JasperReports files
 */


@NamedQueries( {
	@NamedQuery(name = "findTemplateByPhysicianID", query = "SELECT OBJECT(o) FROM Template o WHERE o.physicianID = :physicianID ORDER BY o.expiry ASC"),
	@NamedQuery(name = "findTemplateByTypeAndPhysicianID", query = "SELECT OBJECT(o) FROM Template o WHERE o.type = :type AND o.physicianID = :physicianID ORDER BY o.expiry ASC"),
	@NamedQuery(name = "findTemplateByType", query = "SELECT OBJECT(o) FROM Template o WHERE o.type = :type ORDER BY o.expiry ASC"),
	@NamedQuery(name = "getTemplatesByType", query = "SELECT OBJECT(o) FROM Template o WHERE o.type = :type ORDER BY o.physicianID, o.expiry ASC")})
	@NamedQuery(name = "getTemplateByTypePhysicianAndExpiry", query = "SELECT OBJECT(o) FROM Template o WHERE o.type = :type AND o.physicianID = :physicianID AND (o.expiry >= :dateOfInterest OR o.expiry IS NULL) ORDER BY o.expiry ASC")

	
	
@Entity
@Table(name="templates", schema="core")
public class Template extends GECAMedEntityBean implements Serializable {

	private static final long serialVersionUID = 1L;
	
	public static final Integer OFFICE = -1;  

	private String type;
	private String name;
	private Integer physicianID;
	private Date    expiry;
	private byte[] jrxml;
	private byte[] jasper;
	
	/**
	 * @return Returns the .jasper file.
	 */
	@Column(name = "jasper")
	public byte[] getJasper() {
		return jasper;
	}
	
	/**
	 * @param jasper The .jasper file to set.
	 */
	public void setJasper(byte[] jasper) {
		this.jasper = jasper;
	}
	
	/**
	 * @return Returns the .jrxml file.
	 */
	@Column(name = "jrxml")
	public byte[] getJrxml() {
		return jrxml;
	}
	
	/**
	 * @param jrxml The .jrxml file to set.
	 */
	public void setJrxml(byte[] jrxml) {
		this.jrxml = jrxml;
	}
	
	/**
	 * @return Returns the physicianID.
	 */
	@Column(name = "physician")
	public Integer getPhysicianID() {
		return physicianID;
	}
	
	/**
	 * @param physicianID The physicianID to set.
	 */
	public void setPhysicianID(Integer physicianID) {
		this.physicianID = physicianID;
	}
	
	/**
	 * @return Returns the expiry date for this template.
	 */
	@Column(name = "expiry")
	public Date getExpiry() {
		return this.expiry;
	}
	/**
	 * @param expiry The new expiry date for this template.
	 */
	public void setExpiry(Date expiry) {
		this.expiry = expiry;
	}
	/**
	 * @return Returns the name.
	 */
	@Column(name = "name")
	public String getName() {
		return name;
	}
	/**
	 * @param name The name of the template to set.
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * @return Returns the type of the template.
	 */
	@Column(name = "type")
	public String getType() {
		return type;
	}
	/**
	 * @param type The type of the template to set.
	 */
	public void setType(String type) {
		this.type = type;
	}

	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	@Transient
	public String toString() {
		return this.name + " [" + this.physicianID + "]";
	}
	
}
