/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

import lu.tudor.santec.gecamed.core.utils.AutoTranslatable;

/**
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 * 
 * Entity Bean that maps the <b>core.nationality</b> table
 * which stores a list of all available nationalities
 * 
 */


@javax.persistence.NamedQueries({

    @javax.persistence.NamedQuery(name="findAllNationality",
        query="SELECT OBJECT(o) FROM Nationality o"),
    @javax.persistence.NamedQuery(name="findAllNationalityByValue",
        query="SELECT OBJECT(o) FROM Nationality o WHERE o.value = :value")
})

@Entity
@Table(name="nationality", schema="core")
public class Nationality extends GECAMedEntityBean implements AutoTranslatable, Serializable {

	public static final String LUXEMBOURGISH = "luxembourgish";
	public static final String GERMAN = "german";
	public static final String FRENCH = "french";
	public static final String ENGLISH = "english";
	
	private static final long serialVersionUID = 1L;

	private String value;

	/**
	 * Get the nationality
	 *
	 * @return The nationality.
	 */
	@javax.persistence.Column(name = "value")
	public java.lang.String getValue() {
		return value;
	}

	/**
	 * Set the nationality.
	 *
	 * @param value The nationality.
	 */
	public void setValue(String nationality) {
		this.value = nationality;
	}

	
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return this.getValue();
    }

	@Override
	public boolean equals(Object obj) {
		try {
			return this.getValue().equals(((Nationality)obj).getValue());
		} catch (Exception e) {
			return false;
		}		
	}
	

	@Transient
	public String getTranslationKey ()
	{
		return getClass().getSimpleName() + "." + getValue();
	}
	
	
	@Transient
	public String getDefaultTranslation ()
	{
		return toString();
	}
}
