/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

//***************************************************************************
//***************************************************************************
//* Class Definition and Members	                                          *
//***************************************************************************
//***************************************************************************



@Entity
@Table(name = "national_holiday", schema = "core")

@javax.persistence.NamedQueries 
({
@NamedQuery(name = "getAllNationalHolidays", 	query = "SELECT OBJECT(o) FROM NationalHoliday o ORDER BY o.id,o.date ASC")
})

/**
 * 
 * Entity Bean that maps the <b>core.national_holiday</b> table
 * which stores a list of all available national holidays
 * @author nmac
 * @created 06/04/26
 */
public class NationalHoliday extends GECAMedEntityBean implements Serializable 
	{
	private static final long serialVersionUID = 1L;
	
	private Date	m_Date;
	private String	m_Name;
	private Boolean	m_IsLegal;

//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************	
	
//***************************************************************************
//* Getter and Setter Methods	                                              *
//***************************************************************************	

//---------------------------------------------------------------------------
/**
 * Returns the date of this national holiday
 * @return this national holidays date
 */
//---------------------------------------------------------------------------

@javax.persistence.Column (name ="day")

public Date getDate() 
	{
	return this.m_Date;
	}

//---------------------------------------------------------------------------
/**
 * Sets this national holida' date to the specified value
 * @param p_Date specifies the date for this national holiday
 */
//---------------------------------------------------------------------------

public void setDate (Date p_Date) 
	{
	this.m_Date = p_Date;
	}

//---------------------------------------------------------------------------
/**
 * @return Returns the full name of this national holiday
 */
//---------------------------------------------------------------------------

@javax.persistence.Column (name ="description")

public String getName() 
	{
	return this.m_Name;
	}

//---------------------------------------------------------------------------
/**
 * Sets the full name of this national holiday
 * @param p_Name specifies the new name for this holiday.
 */
//---------------------------------------------------------------------------

public void setName (String p_Name) 
	{
	this.m_Name = p_Name;
	}

//---------------------------------------------------------------------------
/**
 * tells whether this national holiday is a legal holiday or not
 * (Union des Caisse de Maladie) or not. 
 * @return Returns <b>true</b> if national holiday is a legal one,
 * <b>false</b> otherwise.
 */
//---------------------------------------------------------------------------

@javax.persistence.Column (name ="legal")

public Boolean getIsLegal() 
	{
	return this.m_IsLegal;
	}

//---------------------------------------------------------------------------
/**
 * Sets the legal status of this national holiday
 * @param p_IsLegal specifies the new legal status of this national holiday
 */
//---------------------------------------------------------------------------

public void setIsLegal (Boolean p_IsLegal) 
	{
	this.m_IsLegal = p_IsLegal;
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************

}
