/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

import lu.tudor.santec.gecamed.core.utils.AutoTranslatable;

/**
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 * 
 * Entity Bean that maps the <b>core.marital_status</b> table
 * which stores a list of all available marital states
 * 
 */


@javax.persistence.NamedQueries({

    @javax.persistence.NamedQuery(name="findAllMaritalStatus",
        query="SELECT OBJECT(o) FROM MaritalStatus o"),
    @javax.persistence.NamedQuery(name="findAllMaritalStatusByValue",
        query="SELECT OBJECT(o) FROM MaritalStatus o WHERE o.value = :value")
})

@Entity
@Table(name="marital_status", schema="core")
public class MaritalStatus extends GECAMedEntityBean implements AutoTranslatable, Serializable {

	public static final String SEPARATED 	="separated";
	public static final String DIVORCED 	="divorced";
	public static final String MARRIED		="married";
	public static final String SINGLE	    ="single";
	public static final String WIDOWED    	="widowed";
	//FACT-HIS add variable here
	public static final String PARTNERSHIP  ="partnership";
	public static final String OTHER		="other";
	
	private static final long serialVersionUID = 1L;
	/** Regular field. */
	private String value;

	/**
	 * Get the marital status.
	 *
	 * @return The marital status.
	 */
	@javax.persistence.Column(name = "value")
	public java.lang.String getValue() {
		return value;
	}

	/**
	 * Set the marital status.
	 *
	 * @param maritalStatus The marital status.
	 */
	public void setValue(String maritalStatus) {
		this.value = maritalStatus;
	}

	
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return this.getValue();
    }

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		try {
			return this.getValue().equals(((MaritalStatus)obj).getValue());
		} catch (Exception e) {
			return false;
		}		
	}
	
	
	@Transient
	public String getTranslationKey ()
	{
		return getClass().getSimpleName() + "." + getValue();
	}
	

	@Transient
	public String getDefaultTranslation ()
	{
		return getValue();
	}
    
    
}
