/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

import lu.tudor.santec.gecamed.core.utils.AutoTranslatable;

/**
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 * 
 * Entity Bean that maps the <b>core.language</b> table
 * which stores a list of all available languages
 * 
 */


@javax.persistence.NamedQueries({

    @javax.persistence.NamedQuery(name="findAllLanguages",
        query="SELECT OBJECT(o) FROM Language o"),
    @javax.persistence.NamedQuery(name="findAllLanguagesByValue",
        query="SELECT OBJECT(o) FROM Language o WHERE o.value = :value")
})

@Entity
@Table(name="language", schema="core")
public class Language extends GECAMedEntityBean implements AutoTranslatable, Serializable {

	public static final String LUXEMBOURGISH = "luxembourgish";
	public static final String GERMAN = "german";
	public static final String FRENCH = "french";
	public static final String ENGLISH = "english";
	
	private static final long serialVersionUID = 1L;
	/** Regular field. */
	private String value;

	/**
	 * Get the language.
	 *
	 * @return The language.
	 */
	@javax.persistence.Column(name = "value")
	public java.lang.String getValue() {
		return value;
	}

	/**
	 * Set the language.
	 *
	 * @param value The language.
	 */
	public void setValue(String language) {
		this.value = language;
	}

	
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return this.getValue();
    }
    
    
    @Transient
	public String getTranslationKey ()
	{
		return Language.class.getSimpleName() + "." + getValue();
	}
	
	
	@Transient
	public String getDefaultTranslation ()
	{
		return toString();
	}    
    
}
