/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.cara.gui;

import ij.ImagePlus;
import ij.io.Opener;

import java.awt.BorderLayout;
import java.io.File;

import javax.swing.JDialog;
import javax.swing.JFrame;

import lu.tudor.santec.dicom.gui.viewer.DicomImageAngleMeasurement;
import lu.tudor.santec.dicom.gui.viewer.DicomImageInverter;
import lu.tudor.santec.dicom.gui.viewer.DicomImageMeasurement;
import lu.tudor.santec.dicom.gui.viewer.DicomImagePanel;

public class DicomImageDialog extends JDialog {
	private static final long serialVersionUID = 1L;
	private DicomImagePanel imagePanel;
	private Opener opener;
	private DicomImagePanel imageArea;
	
	public DicomImageDialog(JFrame parent) {
		super(parent);
		this.setLayout(new BorderLayout());
		
		imageArea = new DicomImagePanel(10, 10, true, false,false);
		imagePanel = imageArea.createBigArea();
		imagePanel.setImageSize(600,600);
		imagePanel.setShowDicomInfos(true);
		new DicomImageMeasurement(imageArea);
		new DicomImageAngleMeasurement(imageArea);
		new DicomImageInverter(imageArea);
		this.add(imagePanel, BorderLayout.CENTER);
		this.add(imagePanel.createToolBar(), BorderLayout.WEST);
		
		opener = new Opener();
		
		this.pack();
	}
	
	
	public void showImage(File f) {
		try {
			imageArea.setImage(opener.openImage(f.getAbsolutePath()));			
		} catch (Exception e) {
			e.printStackTrace();
		}
		this.setVisible(true);
	}
	
	public void showImage(ImagePlus ip) {
		try {
			imageArea.setImage(ip);			
		} catch (Exception e) {
			e.printStackTrace();
		}
		this.setVisible(true);
	}

}
