/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.cara.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Toolkit;

import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.text.html.HTMLEditorKit;

import lu.tudor.santec.gecamed.core.gui.widgets.ModuleHeader;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.i18n.Translatrix;

public class CaraReportViewer extends JDialog {

	private static final long serialVersionUID = 1L;
	private ModuleHeader titlePanel;
	private JEditorPane editor;
	private int height = 600;
	private String title = Translatrix.getTranslationString("Report.Title");

	public CaraReportViewer() {
		initViewer();
	}
	
	public CaraReportViewer(JFrame parent) {
		super(parent);
		initViewer();
	}
		
	private void initViewer() {
		setTitle(title);

		this.setDefaultCloseOperation(JDialog.HIDE_ON_CLOSE);
		
		this.setLayout(new BorderLayout());

		this.titlePanel = new ModuleHeader(title, PatientManagerModule.getIcon(PatientManagerModule.HOSP_REPORT), new Color(180,255,180));
		this.add(titlePanel, BorderLayout.NORTH);
		
		this.editor = new JEditorPane();
		this.editor.setEditable(false);
		this.editor.setEditorKit(new HTMLEditorKit());
		
		this.add(new JScrollPane(this.editor), BorderLayout.CENTER);
		
		height = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight() - 60;
		this.setLocation(30,30);
		
		this.setSize((int)(height/1.4142),  height);
		
	};
	
	
	public void showDocument(String doc) {
		this.editor.setText(doc);
		this.setVisible(true);
	}
	
	@Override
	public void setVisible(boolean b) {
		if (!b) {
			showDocument("");
		}
		super.setVisible(b);
	}

}
