/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.cara.ejb.session.beans;

import java.util.Collection;

import javax.annotation.security.RolesAllowed;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import lu.tudor.santec.gecamed.cara.ejb.entity.beans.CaraImage;
import lu.tudor.santec.gecamed.cara.ejb.entity.beans.MedicalInfo;
import lu.tudor.santec.gecamed.cara.ejb.entity.beans.Study;
import lu.tudor.santec.gecamed.cara.ejb.session.interfaces.CaraManagerInterface;


@Remote({CaraManagerInterface.class})
@Stateless
public class CaraManagerBean implements CaraManagerInterface 
{
    //~ Static fields/initializers =============================================

    private static final long serialVersionUID = 1L;
	
    @PersistenceContext (unitName="gecam")
	EntityManager em;
	
    //~ Methods ================================================================

    @SuppressWarnings("unchecked")
	@RolesAllowed("gecam")
    public MedicalInfo getMedicalInfo(Integer patientID) throws Exception
    {
		try {
			Query q = em.createNamedQuery(MedicalInfo.findMedicalInfoByPatientID).setParameter("patientID", patientID);
			return (MedicalInfo) q.getSingleResult();
		} catch (Exception e) {
			return null;
		}
	}

	@SuppressWarnings("unchecked")
	public Collection<Study> getStudies(Integer patientID) throws Exception {
		try {
			Query q = em.createNamedQuery(Study.findStudiesByPatientID).setParameter("patientID", patientID);
			Collection<Study> studies = q.getResultList();	
			return  studies;
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	public CaraImage getImage(String imageID) throws Exception {
		try {
			System.out.println("get Image: " + imageID);
			Query q = em.createNamedQuery(CaraImage.findImageByID).setParameter("imageID", imageID);
			return  (CaraImage) q.getResultList().iterator().next();	
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}
	
	public Boolean imageExists(String imageID) {
		Long imageCount = (Long) em.createNamedQuery(CaraImage.getImageNrForID)
		.setParameter("imageID", imageID)
		.getSingleResult();
		if (imageCount > 0 ) {
			return true;
		}
		return false;
	}
	
	@SuppressWarnings("unchecked")
	public byte[] getThumbnail(String imageID) throws Exception {
		try {
			System.out.println("get Thumb: " + imageID);
			Query q = em.createNamedQuery(CaraImage.findThumbByID).setParameter("imageID", imageID);
			Collection images = q.getResultList();
			for(Object im : images) {
				return (byte[]) im;
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
	
	@SuppressWarnings("unchecked")
	public Object[] getImageInfos(String imageID) throws Exception {
		try {
			Query q = em.createNamedQuery(CaraImage.findInfoByID).setParameter("imageID", imageID);
			Collection infos = q.getResultList();
			for(Object in : infos) {
				return (Object[]) in;
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
	    
}
