/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.cara.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * Author: Johannes Hermen Tudor/Santec
 */

@javax.persistence.NamedQueries({

	@javax.persistence.NamedQuery(name=Study.findStudiesByPatientID,
		query="SELECT OBJECT(o) FROM Study o WHERE o.patientID = :patientID ORDER BY o.date DESC"),

	@javax.persistence.NamedQuery(name=Study.findStudiesByAccesionNumber,
			query="SELECT OBJECT(o) FROM Study o WHERE o.accessionNumber = :accessionNumber"),

	@javax.persistence.NamedQuery(name=Study.findStudyByDicomID,
			query="SELECT OBJECT(o) FROM Study o WHERE o.dicomIDs = :dicomID")
	})

@Entity
@Table(name="study", schema="cara")
public class Study extends GECAMedEntityBean implements Serializable {

	public static final String findStudiesByPatientID  		= "findStudiesByPatientID";	
	public static final String findStudiesByAccesionNumber  = "findStudiesByAccessionNumber";	
	public static final String findStudyByDicomID  			= "findStudiesByDicomID";	
	
	private static final long serialVersionUID = 1L;

	/** the gecamed patient ID */
	private Integer patientID;
	
	/** the cara study ID */
	private String caraID;
	
	/** the hospital study ID */
	private String hospID;
	
	/** the cara study desc. */
	private String caraDescription;
	
	/** the hosp study desc. */
	private String hospDescription;
	
	/** the cara study code */
	private String caraStudyCode;
	
	/** the hosp study code */
	private String hospStudyCode;
	
	/** the modality (device) */
	private String modality;
	
	/** the laterality (left/right etc...) */
	private String laterality;
	
	/** the incidence */
	private String incidence;
	
	/** the study date */
	private Date date;
	
	/** the prescription date */
	private Date prescriptionDate;
	
	/** the prescribing physician */
	private String prescribingPhysician;
	
	/** the hospital */
	private String hospital;
	
	/** the responsable physician (radiologist) */
	private String responsiblePhysician;
	
	/** events during the exam */
	private String events;
	
	/** used contrast products */
	private String contrastProduct;
	
	/** volume of used contrast product */
	private Double contrastProductVolume;
	
	/** used isotope */
	private String isotope;
	
	/** activity of used isotope (mCi) */
	private Double activity;
	
	/** ths status of the study (planed etc...) */
	private String status;
	
	/** IDs of the DICOM image(s) */
	private String dicomIDs;
	
	/** the report as text */
	private String report;
	
	private String accessionNumber;
	/**
	 * @return Returns the hosp_id.
	 */
	@javax.persistence.Column(name = "hosp_id")
	public String getHospID() {
		return hospID;
	}

	/**
	 * @param hospID The hospID to set.
	 */
	public void setHospID(String hospID) {
		this.hospID = hospID;
	}

	/**
	 * @return Returns the caraID.
	 */
	@javax.persistence.Column(name = "cara_id")
	public String getCaraID() {
		return caraID;
	}

	/**
	 * @param name The name to set.
	 */
	public void setCaraID(String caraID) {
		this.caraID = caraID;
	}


	/**
	 * @return the caraDescription
	 */
	@javax.persistence.Column(name = "cara_desc")
	public String getCaraDescription() {
		return caraDescription;
	}

	/**
	 * @param caraDescription the caraDescription to set
	 */
	public void setCaraDescription(String caraDescription) {
		this.caraDescription = caraDescription;
	}

	/**
	 * @return the patientID
	 */
	@javax.persistence.Column(name = "patient_id")
	public Integer getPatientID() {
		return patientID;
	}

	/**
	 * @param patientID the patientID to set
	 */
	public void setPatientID(Integer patientID) {
		this.patientID = patientID;
	}

	/**
	 * @return the activity
	 */
	@javax.persistence.Column(name = "activity")
	public Double getActivity() {
		return activity;
	}

	/**
	 * @param activity the activity to set
	 */
	public void setActivity(Double activity) {
		this.activity = activity;
	}

	/**
	 * @return the caraStudyCode
	 */
	@javax.persistence.Column(name = "cara_study_code")
	public String getCaraStudyCode() {
		return caraStudyCode;
	}

	/**
	 * @param caraStudyCode the caraStudyCode to set
	 */
	public void setCaraStudyCode(String caraStudyCode) {
		this.caraStudyCode = caraStudyCode;
	}

	/**
	 * @return the contrastProduct
	 */
	@javax.persistence.Column(name = "contrast_product")
	public String getContrastProduct() {
		return contrastProduct;
	}

	/**
	 * @param contrastProduct the contrastProduct to set
	 */
	public void setContrastProduct(String contrastProduct) {
		this.contrastProduct = contrastProduct;
	}

	/**
	 * @return the contrastProductVolume
	 */
	@javax.persistence.Column(name = "contrast_product_volume")
	public Double getContrastProductVolume() {
		return contrastProductVolume;
	}

	/**
	 * @param contrastProductVolume the contrastProductVolume to set
	 */
	public void setContrastProductVolume(Double contrastProductVolume) {
		this.contrastProductVolume = contrastProductVolume;
	}

	/**
	 * @return the date
	 */
	@javax.persistence.Column(name = "date")
	public Date getDate() {
		return date;
	}

	/**
	 * @param date the date to set
	 */
	public void setDate(Date date) {
		this.date = date;
	}

	/**
	 * @return the events
	 */
	@javax.persistence.Column(name = "events")
	public String getEvents() {
		return events;
	}

	/**
	 * @param events the events to set
	 */
	public void setEvents(String events) {
		this.events = events;
	}

	/**
	 * @return the hospDescription
	 */
	@javax.persistence.Column(name = "hosp_desc")
	public String getHospDescription() {
		return hospDescription;
	}

	/**
	 * @param hospDescription the hospDescription to set
	 */
	public void setHospDescription(String hospDescription) {
		this.hospDescription = hospDescription;
	}

	/**
	 * @return the hospital
	 */
	@javax.persistence.Column(name = "hospital")
	public String getHospital() {
		return hospital;
	}

	/**
	 * @param hospital the hospital to set
	 */
	public void setHospital(String hospital) {
		this.hospital = hospital;
	}

	/**
	 * @return the hospStudyCode
	 */
	@javax.persistence.Column(name = "hosp_study_code")
	public String getHospStudyCode() {
		return hospStudyCode;
	}

	/**
	 * @param hospStudyCode the hospStudyCode to set
	 */
	public void setHospStudyCode(String hospStudyCode) {
		this.hospStudyCode = hospStudyCode;
	}

	/**
	 * @return the incidence
	 */
	@javax.persistence.Column(name = "incidence")
	public String getIncidence() {
		return incidence;
	}

	/**
	 * @param incidence the incidence to set
	 */
	public void setIncidence(String incidence) {
		this.incidence = incidence;
	}

	/**
	 * @return the isotope
	 */
	@javax.persistence.Column(name = "isotope")
	public String getIsotope() {
		return isotope;
	}

	/**
	 * @param isotope the isotope to set
	 */
	public void setIsotope(String isotope) {
		this.isotope = isotope;
	}

	/**
	 * @return the laterality
	 */
	@javax.persistence.Column(name = "laterality")
	public String getLaterality() {
		return laterality;
	}

	/**
	 * @param laterality the laterality to set
	 */
	public void setLaterality(String laterality) {
		this.laterality = laterality;
	}

	/**
	 * @return the modality
	 */
	@javax.persistence.Column(name = "modality")
	public String getModality() {
		return modality;
	}

	/**
	 * @param modality the modality to set
	 */
	public void setModality(String modality) {
		this.modality = modality;
	}

	/**
	 * @return the prescribingPhysician
	 */
	@javax.persistence.Column(name = "prescribing_physician")
	public String getPrescribingPhysician() {
		return prescribingPhysician;
	}

	/**
	 * @param prescribingPhysician the prescribingPhysician to set
	 */
	public void setPrescribingPhysician(String prescribingPhysician) {
		this.prescribingPhysician = prescribingPhysician;
	}

	/**
	 * @return the prescriptionDate
	 */
	@javax.persistence.Column(name = "prescription_date")
	public Date getPrescriptionDate() {
		return prescriptionDate;
	}

	/**
	 * @param prescriptionDate the prescriptionDate to set
	 */
	public void setPrescriptionDate(Date prescriptionDate) {
		this.prescriptionDate = prescriptionDate;
	}

	/**
	 * @return the responsiblePhysician
	 */
	@javax.persistence.Column(name = "responsable_physician")
	public String getResponsiblePhysician() {
		return responsiblePhysician;
	}

	/**
	 * @param responsiblePhysician the responsiblePhysician to set
	 */
	public void setResponsiblePhysician(String responsiblePhysician) {
		this.responsiblePhysician = responsiblePhysician;
	}

	@javax.persistence.Column(name = "status")
	public String getStatus() {
		return this.status;
	}

	/**
	 * @param status the status to set
	 */
	public void setStatus(String status) {
		this.status = status;
	}

	/**
	 * @return the dicomIDs
	 */
	@javax.persistence.Column(name = "dicom_ids")
	public String getDicomIDs() {
		return dicomIDs;
	}

	/**
	 * @param dicomIDs the dicomIDs to set
	 */
	public void setDicomIDs(String dicomIDs) {
		this.dicomIDs = dicomIDs;
	}

	/**
	 * @return the report
	 */
	@javax.persistence.Column(name = "accession_number")
	public String getAccessionNumber() {
		return accessionNumber;
	}

	/**
	 * @param report the report to set
	 */
	public void setAccessionNumber(String accessionNumber) {
		this.accessionNumber = accessionNumber;
	}

	/**
	 * @return the report
	 */
	@javax.persistence.Column(name = "report")
	public String getReport() {
		return report;
	}

	/**
	 * @param report the report to set
	 */
	public void setReport(String report) {
		this.report = report;
	}

}
