package lu.tudor.santec.gecamed.billing.utils.rules;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import lu.tudor.santec.gecamed.billing.utils.BillingAdminSettings;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: RuleOptions.java,v $
 */

public class RuleOptions implements Serializable
{
	/* ======================================== */
	// CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	/** the logger Object for this class */
	private static org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(RuleOptions.class.getName());
	
	
	
	/* ======================================== */
	// MEMBERS
	/* ======================================== */
	
	private boolean	sessionMode;
	private int		hospitalizedCumulationMode;
	private int		tiersPayantMinValue;
	private Date	patientsBirthday;
	
	
	
	/* ======================================== */
	// CONSTRUCTORS
	/* ======================================== */
	
	public RuleOptions (boolean sessionMode, int hospitalizedCumulationMode, Date patientsBirthday, int tiersPayantMinValue)
	{
		this.sessionMode				= sessionMode;
		this.hospitalizedCumulationMode	= hospitalizedCumulationMode;
		this.tiersPayantMinValue		= tiersPayantMinValue;
		setPatientsBirthday(patientsBirthday);
	}
	
	
	public RuleOptions (Boolean sessionMode, Integer hospitalizedCumulationMode, Date patientsBirthday, Integer tiersPayantMinValue)
	{
		init(sessionMode, hospitalizedCumulationMode, patientsBirthday, tiersPayantMinValue);
	}
	
	
	private void init (Boolean sessionMode, Integer hospitalizedCumulationMode, Date patientsBirthday, Integer tiersPayantMinValue)
	{
		if (sessionMode == null)
		{
			this.sessionMode = BillingAdminSettings.c_UseSessionModeDefault;
			logger.info("Using default for rule option "+BillingAdminSettings.c_UseSessionMode+" ("+sessionMode+")");
		}
		else
		{
			this.sessionMode	= sessionMode.booleanValue();
		}
		
		if (hospitalizedCumulationMode == null)
		{
			this.hospitalizedCumulationMode = BillingAdminSettings.c_HospitalizedCumulationModeDefault;
			logger.info("Using default for rule option "+BillingAdminSettings.c_HospitalizedCumulationMode+" ("+this.hospitalizedCumulationMode+")");
		}
		else
		{
			this.hospitalizedCumulationMode	= hospitalizedCumulationMode.intValue();
		}
		
		if (tiersPayantMinValue == null)
		{
			this.tiersPayantMinValue = BillingAdminSettings.c_TiersPayantMinValueDefault;
			logger.info("Using default for rule option "+BillingAdminSettings.c_TiersPayantMinValue+" ("+tiersPayantMinValue+")");
		}
		else
		{
			this.tiersPayantMinValue	= tiersPayantMinValue.intValue();
		}
		
		setPatientsBirthday(patientsBirthday);
	}
	
	
	private void setPatientsBirthday (Date date)
	{
		if (date == null)
		{
			Calendar cal = new GregorianCalendar();
			cal.setTime(new Date());
			cal.set(Calendar.YEAR, (-1) * BillingAdminSettings.c_RuleOptionPatientAge);
			this.patientsBirthday	= cal.getTime();
			logger.info("Using default for rule option value of patient's age ("+BillingAdminSettings.c_RuleOptionPatientAge+")");
		}
		else
		{
			this.patientsBirthday	= date;
		}
	}
	
	
	public boolean isSessionMode ()
	{
		return sessionMode;
	}
	
	
	public int getHospitalizedCumulationMode ()
	{
		return hospitalizedCumulationMode;
	}
	
	
	public int getTiersPayantMinValue ()
	{
		return tiersPayantMinValue;
	}
	
	
	public Date getPatientsBirthday ()
	{
		return patientsBirthday;
	}
}
