package lu.tudor.santec.gecamed.billing.utils.rules;

import java.util.Collection;
import java.util.HashSet;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Act;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: AgeChangeCondition.java,v $
 */

public class AgeChangeCondition implements ActChangeCondition
{
	/* ======================================== */
	// MEMBERS
	/* ======================================== */
	
	private String defaultCode;
	private String youngerThan2YearsCode;
	private String from2to4YearsCode;
	private String from4to6YearsCode;
	private String from6to14YearsCode;
	private String from14to18YearsCode;
	private String olderThan75YearsCode;
	
	private HashSet<String>	specialCodes	= new HashSet<String>();
	private HashSet<String>	allCodes		= new HashSet<String>();
	
	
	
	/* ======================================== */
	// CONSTRUCTORS
	/* ======================================== */
	
	public AgeChangeCondition (String defaultCode, String youngerThan2YearsCode, String from2to4YearsCode, 
			String from4to6YearsCode, String from6to14YearsCode, String from14to18YearsCode, String olderThan75YearsCode)
	{
		this.youngerThan2YearsCode	= youngerThan2YearsCode;
		this.from2to4YearsCode		= from2to4YearsCode;
		this.from4to6YearsCode		= from4to6YearsCode;
		this.from6to14YearsCode		= from6to14YearsCode;
		this.from14to18YearsCode	= from14to18YearsCode;
		this.olderThan75YearsCode	= olderThan75YearsCode;
		init(defaultCode);
	}
	
	
	public AgeChangeCondition (String defaultCode, String youngerThan18YearsCode)
	{
		this(defaultCode, youngerThan18YearsCode, youngerThan18YearsCode, youngerThan18YearsCode, 
				youngerThan18YearsCode, youngerThan18YearsCode, null);
	}
	
	
	
	/* ======================================== */
	// CLASS BODY
	/* ======================================== */
	
	public String getCodeToChangeTo (RulesObjectsHolder roh, Act act)
	{
		int		age		= roh.getPatientAgeOnDayOfAct(act);
		String	newCode	= null;
		
		if (age < 2)
			newCode	= youngerThan2YearsCode;
		else if (age < 4)
			newCode	= youngerThan2YearsCode;
		else if (age < 6)
			newCode	= youngerThan2YearsCode;
		else if (age < 14)
			newCode	= youngerThan2YearsCode;
		else if (age < 18)
			newCode	= youngerThan2YearsCode;
		else if (age >= 75)
			newCode	= youngerThan2YearsCode;
		else if (specialCodes.contains(act.getCode()))
			newCode	= defaultCode;
		
		return newCode;
	}
	
	
	public Collection<String> getCodesToChange ()
	{
		return allCodes;
	}
	
	
	public void setDefaultCode (String defaultCode)
	{
		this.defaultCode = defaultCode;
	}
	
	
	
	/* ======================================== */
	// HELP METHODS
	/* ======================================== */
	
	private void init (String defaultCode)
	{
		allCodes.add(defaultCode);
		init();
	}
	
	
//	private void init (Collection<String> defaultCodes)
//	{
//		allCodes.addAll(defaultCodes);
//		init();
//	}
	
	
	private void init ()
	{
		specialCodes.add(youngerThan2YearsCode);
		specialCodes.add(from2to4YearsCode);
		specialCodes.add(from4to6YearsCode);
		specialCodes.add(from6to14YearsCode);
		specialCodes.add(from14to18YearsCode);
		specialCodes.add(olderThan75YearsCode);
		allCodes.addAll(specialCodes);
	}
}
